% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_all_nodes_parser.R
\name{parse_drug_element}
\alias{parse_drug_element}
\title{Extracts the given drug elements and return data as list of dataframes.}
\usage{
parse_drug_element(elements_options = c("all"), save_table = FALSE)
}
\arguments{
\item{elements_options}{list,  options of elements to be parsed. Default is "all"}

\item{save_table}{boolean, save table in database if true. Default is false.}
}
\value{
list of selected drug elements dataframes
}
\description{
\code{parse_drug_element} returns list of dataframes of drugs selected elements.
}
\details{
This functions extracts selected element of drug nodes in drug bank
xml database with the option to save it in a predefined database via
\code{\link{open_db}} method. It takes one single optional argument to
save the returned dataframe in the database.
It must be called after \code{\link{get_xml_db_rows}} function like
any other parser function.
If \code{\link{get_xml_db_rows}} is called before for any reason, so
no need to call it again before calling this function.

parse_drug_element_options can be called to know the valid options for
this method
}
\examples{
\donttest{
parse_drug_element()
parse_drug_element(c("drug_ahfs_codes", "drug_carriers"), save_table = TRUE)
parse_drug_element(save_table = FALSE)
parse_drug_element(c("drug_ahfs_codes", "drug_carriers"))
}
}
