% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_query.R
\name{make_datelife_query}
\alias{make_datelife_query}
\title{Go from taxon names to a \code{datelifeQuery} object}
\usage{
make_datelife_query(
  input = c("Rhea americana", "Pterocnemia pennata", "Struthio camelus"),
  use_tnrs = TRUE,
  get_spp_from_taxon = FALSE
)
}
\arguments{
\item{input}{Taxon names as one of the following:
\describe{
\item{A character vector of taxon names}{With taxon names as a single comma separated starting or concatenated with \code{\link[=c]{c()}}.}
\item{A phylogenetic tree with taxon names as tip labels}{As a \code{phylo} or \code{multiPhylo}
object, OR as a newick character string.}
}}

\item{use_tnrs}{Whether to use Open Tree of Life's Taxonomic Name Resolution Service (TNRS)
to process input taxon names. Default to \code{TRUE}, it corrects misspellings and
taxonomic name variations with \code{\link[=tnrs_match]{tnrs_match()}}, a wrapper of \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}}.}

\item{get_spp_from_taxon}{Whether to search ages for all species belonging to a
given taxon or not. Default to \code{FALSE}. If \code{TRUE}, it must have same length as input.
If input is a newick string with some clades it will be converted to a \code{phylo}
object, and the order of \code{get_spp_from_taxon} will match \code{phy$tip.label}.}
}
\value{
A \code{datelifeQuery} object, which is a list of three elements:
\describe{
\item{$phy}{A \code{phylo} object or \code{NA}, if input is not a tree.}
\item{$cleaned_names}{A character vector of cleaned taxon names.}
\item{$ott_ids}{A numeric vector of OTT ids if \code{use_tnrs = TRUE}, or \code{NULL} if \code{use_tnrs = FALSE}.}
}
}
\description{
Go from taxon names to a \code{datelifeQuery} object
}
\details{
It processes \code{phylo} objects and newick character string inputs
with \code{\link[=input_process]{input_process()}}. If \code{input} is a \code{multiPhylo} object, only the first \code{phylo}
element will be used. Similarly, if an \code{input} newick character string has multiple trees,
only the first one will be used.
}
