% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_calibrations_treePL.R
\name{use_calibrations_treePL}
\alias{use_calibrations_treePL}
\title{Date a tree with initial branch lengths with treePL.}
\usage{
use_calibrations_treePL(phy, calibrations)
}
\arguments{
\item{phy}{A \code{phylo} object with or without branch lengths.}

\item{calibrations}{A \code{data.frame} of secondary calibrations for any pair of taxon
names in \code{phy}, usually obtained with \code{\link[=get_all_calibrations]{get_all_calibrations()}}.}
}
\value{
A phylo object
}
\description{
Date a tree with initial branch lengths with treePL.
}
\details{
This function uses treePL as described in Smith, S. A., & O’Meara, B. C. (2012).
\doi{10.1093/bioinformatics/bts492}, with
the function \code{treePL.phylo}. It attempts to use the calibrations as fixed ages.
If that fails (often due to conflict between calibrations), it will expand the
range of the minimum age and maximum age and try again. And repeat.
If expand = 0, it uses the summarized calibrations.
In some cases, it returns edge lengths in relative time (with maximum tree depth = 1)
instead of absolute time, as given by calibrations. In this case, the function returns NA.
This is an issue from PATHd8.
}
\references{
Smith, S. A., & O’Meara, B. C. (2012).
"treePL: divergence time estimation using penalized likelihood for large phylogenies".
Bioinformatics, 28(20), 2689-2690, \doi{10.1093/bioinformatics/bts492}.
}
