% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rescale.R
\name{data_rescale}
\alias{data_rescale}
\alias{change_scale}
\alias{data_rescale.numeric}
\alias{data_rescale.grouped_df}
\alias{data_rescale.data.frame}
\title{Rescale Variables to a New Range}
\usage{
data_rescale(x, ...)

change_scale(x, ...)

\method{data_rescale}{numeric}(x, to = c(0, 100), range = NULL, verbose = TRUE, ...)

\method{data_rescale}{grouped_df}(
  x,
  to = c(0, 100),
  range = NULL,
  select = NULL,
  exclude = NULL,
  ...
)

\method{data_rescale}{data.frame}(
  x,
  to = c(0, 100),
  range = NULL,
  select = NULL,
  exclude = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric variable.}

\item{...}{Arguments passed to or from other methods.}

\item{to}{New range that the variable will have after rescaling.}

\item{range}{Initial (old) range of values. If \code{NULL}, will take the range of
the input vector (\code{range(x)}).}

\item{verbose}{Toggle warnings and messages on or off.}

\item{select}{Character vector of column names. If \code{NULL} (the default), all
variables will be selected.}

\item{exclude}{Character vector of column names to be excluded from selection.}
}
\value{
A rescaled object.
}
\description{
Rescale variables to a new range.
}
\examples{
data_rescale(c(0, 1, 5, -5, -2))
data_rescale(c(0, 1, 5, -5, -2), to = c(-5, 5))

# Specify the "theoretical" range of the input vector
data_rescale(c(1, 3, 4), to = c(0, 40), range = c(0, 4))

# Dataframes
head(data_rescale(iris, to = c(0, 1)))
head(data_rescale(iris, to = c(0, 1), select = "Sepal.Length"))

# One can specify a list of ranges
head(data_rescale(iris, to = list(
  "Sepal.Length" = c(0, 1),
  "Petal.Length" = c(-1, 0)
)))
}
\seealso{
\code{\link[=normalize]{normalize()}} \code{\link[=standardize]{standardize()}} \code{\link[=ranktransform]{ranktransform()}}

Other transform utilities: 
\code{\link{normalize}()},
\code{\link{ranktransform}()},
\code{\link{standardize}()}
}
\concept{transform utilities}
