% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_metadata.R
\name{file_metadata}
\alias{file_metadata}
\title{Create a file metadata object}
\usage{
file_metadata(
  originator = NULL,
  sys = NULL,
  sys_version = NULL,
  file_oid = NULL,
  version = "1.0.0"
)
}
\arguments{
\item{originator}{originator parameter, defined as "The organization that
generated the Dataset-JSON file."}

\item{sys}{sourceSystem parameter, defined as "The computer system or
database management system that is the source of the information in this
file."}

\item{sys_version}{sourceSystemVersion, defined as "The version of the
sourceSystem"}

\item{file_oid}{fileOID parameter, defined as "A unique identifier for this
file."}

\item{version}{Dataset JSON schema version being used}
}
\value{
file_metadata object
}
\description{
Create a file metadata object
}
\examples{
# Create using parameters
file_meta <- file_metadata(
    originator = "Some Org",
    sys = "source system",
    sys_version = "1.0"
  )

# Set parameters after
file_meta <- file_metadata()

file_meta_updated <- set_file_oid(file_meta, "/some/path")
file_meta_updated <- set_originator(file_meta_updated, "Some Org")
file_meta_updated <- set_source_system(file_meta_updated, "source system", "1.0")
}
