% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_dataset.R, R/dataset.R
\name{as_dataset}
\alias{as_dataset}
\alias{as_dataset.data.frame}
\alias{dataset}
\alias{is.dataset}
\alias{print.dataset}
\alias{summary.dataset}
\title{Create a dataset}
\usage{
as_dataset(
  x,
  author,
  title,
  publisher = NULL,
  year = NULL,
  identifier = NULL,
  description = NULL,
  version = NULL,
  datasubject = NULL,
  language = NULL,
  datasource = NULL,
  rights = NULL
)

\method{as_dataset}{data.frame}(
  x,
  author,
  title,
  publisher = NULL,
  year = NULL,
  identifier = NULL,
  description = NULL,
  version = NULL,
  datasubject = NULL,
  language = NULL,
  datasource = NULL,
  rights = NULL
)

dataset(
  x,
  author,
  title,
  identifier = NULL,
  publisher = NULL,
  year = NULL,
  version = NULL,
  datasubject = NULL,
  description = NULL,
  language = NULL,
  datasource = NULL,
  rights = NULL,
  ...
)

is.dataset(x)

\method{print}{dataset}(x, n, ...)

\method{summary}{dataset}(object, ...)
}
\arguments{
\item{x}{An R object that contains the data of the dataset (a data.frame or
inherited from \code{\link[base:data.frame]{data.frame}}), for example,
\code{\link[tibble:tibble]{tibble::tibble()}}, \code{\link[tsibble:tsibble]{tsibble::tsibble()}}, \code{\link[data.table:data.table]{data.table::data.table()}}.}

\item{author}{A single person or a vector of persons as authors, declared with
\code{\link[utils:person]{person}}.}

\item{title}{The title of the dataset.}

\item{publisher}{The organisation or person that publishes the dataset.
If left empty (NULL), receives the DataCite standard value \code{':tba'}, or to
be announced later.}

\item{year}{The year of the creation of the dataset. If left empty (NULL),
the current year.}

\item{identifier}{The permanent identifier, for example, the DOI of the dataset.
If left empty (NULL), receives the DataCite standard value \code{':tba'}, or to
be announced later.}

\item{description}{The optional \code{Description} property as an attribute to
an R object.}

\item{version}{The version of the dataset. If left empty (NULL), defaults to
\code{'0.1.0'}}

\item{datasubject}{The subject of the data frame, as a \link{subject} type.}

\item{language}{The primary language of the dataset, for example \code{'eng'}.
Defaults to \code{NULL} that sets it to the unassigned value \code{':unas'}.}

\item{datasource}{The source of the dataset,
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/source/}{DCMI: Source},
which corresponds to a \code{relatedItem} in the DataCite vocabulary. We use
\code{datasource} instead of \code{source} to avoid naming conflicts with the
base R  \code{source()} function.}

\item{rights}{Any rights information for this resource. The property may be
repeated to record complex rights characteristics.
Free text, defaults to \code{":unas"} for unassigned values. See \code{\link{rights}}.}

\item{...}{Further arguments passed on to generic methods
like \code{summary(x, ...)}.}

\item{n}{Number of rows to print.}

\item{object}{an object for which a summary is desired.}
}
\value{
A dataset object, which is a data.frame or inherited object with rich
metadata.
}
\description{
Create a dataset
}
\details{
For further information, see the \code{vignette("dataset", package = "dataset")}
vignette.
}
\examples{
ds <- dataset(iris,
        title = "The iris Dataset",
        author = c(
           person(family ="Anderson",
           given ="Edgar",
           role = "aut")
           ),
         identifier = "https://doi.org/10.1111/j.1469-1809.1936.tb02137.x",
         year = "1935",
         version = "1.0",
         description = "The famous dataset that is distributed with R.",
         url = "https://en.wikipedia.org/wiki/Iris_flower_data_set",
         resourceType = "Dataset"
         )
}
\seealso{
\code{\link[=xsd_convert]{xsd_convert()}}
}
