% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{CreateDatetimePartitionSpecification}
\alias{CreateDatetimePartitionSpecification}
\title{Create a list describing datetime partition parameters}
\usage{
CreateDatetimePartitionSpecification(datetimePartitionColumn,
  autopilotDataSelectionMethod = NULL, validationDuration = NULL,
  holdoutStartDate = NULL, holdoutDuration = NULL, gapDuration = NULL,
  numberOfBacktests = NULL, backtests = NULL)
}
\arguments{
\item{datetimePartitionColumn}{character. The name of the column whose values as dates
are used to assign a row to a particular partition}

\item{autopilotDataSelectionMethod}{character. Optional. Whether models created
by the autopilot should use "rowCount" or "duration" as their dataSelectionMethod}

\item{validationDuration}{character. Optional. The default validationDuration for the
backtests}

\item{holdoutStartDate}{character. The start date of holdout scoring data
(RFC 3339 format). If holdoutStartDate is specified, holdoutDuration must also be specified.}

\item{holdoutDuration}{character. Optional. The duration of the holdout scoring data.
If holdoutDuration is specified, holdoutStartDate must also be specified.}

\item{gapDuration}{character. Optional. The duration of the gap between training and
holdout scoring data.}

\item{numberOfBacktests}{integer. The number of backtests to use.}

\item{backtests}{list. List of BacktestSpecification the exact specification of backtests to use.
The indexes of the specified backtests should range from 0 to numberOfBacktests - 1.
If any backtest is left unspecified, a default configuration will be chosen.}
}
\value{
An S3 object of class 'partition' including the parameters required by the
  SetTarget function to generate a datetime partitioning of the modeling dataset.
}
\description{
Uniquely defines a DatetimePartitioning for some project
}
\details{
Includes only the attributes of DatetimePartitioning that are directly controllable by users,
not those determined by the DataRobot application based on the project dataset and the
user-controlled settings.
This is the specification that should be passed to SetTarget via the
partition parameter.  To see the full partitioning based on the project dataset,
GenerateDatetimePartition.
All durations should be specified with a duration string such as those returned
by the ConstructDurationString helper function.
}
\examples{
CreateDatetimePartitionSpecification("date_col")
}
