% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionExplanations.R
\name{GetPredictionExplanationsRows}
\alias{GetPredictionExplanationsRows}
\title{Retrieve all prediction explanations rows}
\usage{
GetPredictionExplanationsRows(project, predictionExplanationId,
  batchSize = NULL, excludeAdjustedPredictions = TRUE)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{predictionExplanationId}{character. Id of the prediction explanations.}

\item{batchSize}{integer. Optional. Maximum number of prediction explanations rows to
retrieve per request}

\item{excludeAdjustedPredictions}{logical. Optional. Set to FALSE to include adjusted
predictions, which are predictions adjusted by an exposure column. This is only relevant for
projects that use an exposure column.}
}
\value{
list of raw prediction explanations, each element corresponds to a row of the
  prediction dataset and has following components.
   \itemize{
     \item rowId. Character string row Id.
     \item prediction. prediction for the row.
     \item predictionValues. list containing
       \itemize{
         \item label. describes what this model output corresponds to. For regression projects,
            it is the name of the target feature. For classification projects, it is a level
            from the  target feature.
         \item value. the output of the prediction.  For regression projects, it is the predicted
            value of the target. For classification projects, it is the predicted probability the
            row belongs to the class identified by the label.
       }
     \item adjustedPrediction. adjusted predictions, if they are not excluded.
     \item adjustedPredictionValues. Similar to predictionValues, but for adjusted predictions,
       if they are not excluded.
     \item predictionExplanations. list containing
       \itemize{
         \item label. described what output was driven by this prediction explanation.
           For regression projects, it is the name of the target feature. For classification
           projects, it is the class whose probability increasing would correspond to a
           positive strength of this prediction explanation.
         \item feature. the name of the feature contributing to the prediction.
         \item featureValue. the value the feature took on for this row
         \item strength. the amount this feature's value affected the prediction
         \item qualitativeStrength. a human-readable description of how strongly the feature
           affected the prediction (e.g. '+++', '--', '+').
       }
   }
}
\description{
Retrieve all prediction explanations rows
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  datasets <- ListPredictionDatasets(projectId)
  dataset <- datasets[[1]]
  datasetId <- dataset$id
  model <- GetModel(projectId, modelId)
  jobId <- RequestPredictionExplanations(model, datasetId)
  predictionExplanationId <- GetPredictionExplanationsMetadataFromJobId(projectId, jobId)$id
  GetPredictionExplanationsRows(projectId, predictionExplanationId)
}
}
