% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatingTables.R
\name{RequestNewRatingTableModel}
\alias{RequestNewRatingTableModel}
\title{Create a new model from a rating table.}
\usage{
RequestNewRatingTableModel(project, ratingTableId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{ratingTableId}{character. The ID of the rating table.}
}
\value{
An integer value that can be used as the modelJobId parameter
  in subsequent calls to the GetModelFromJobId function.
}
\description{
Create a new model from a rating table.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  ratingTableId <- "5984b4d7100d2b31c1166529"
  RequestNewModel(projectId, ratingTableId)
}
}
