% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPredictions.R
\name{GetPredictions}
\alias{GetPredictions}
\title{Retrieve model predictions}
\usage{
GetPredictions(project, predictId, type = "response",
  classPrefix = "class_", maxWait = 600)
}
\arguments{
\item{project}{character. Optional. Either (1) a character string giving the unique
alphanumeric identifier for the project, or (2) a list containing the element
projectId with this identifier.}

\item{predictId}{character or integer. Either can be the character id of the
\code{predictionId} associated with the prediction or the integer \code{predictionJobId}
that is created by the call to \code{RequestPredictions}.}

\item{type}{character. String specifying the type of response for
binary classifiers; see Details.}

\item{classPrefix}{character. For multiclass projects returning prediction probabilities,
this prefix is prepended to each class in the header of the dataframe. Defaults to
"class_".}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the prediction job
to complete.}
}
\value{
Vector of predictions, depending on the modeling task
("Binary", "Multiclass", or "Regression") and the value of the type parameter;
see Details.
}
\description{
This function can be used to retrieve predictions from a project and either
(1) a \code{predictionId} specifying the ID for the predictions desired (use
\code{ListPredictions} to see available predictionIds for individual prediction sets) or
(2) a \code{predictionJobId} that comes from a call to \code{RequestPredictions}.
This function will then return the predictions generated for the model and data
}
\details{
The contents of the return vector depends on both the modeling
task - binary classification, multiclass classification, or regression
- and the value of the type parameter.  For regression tasks, the type
parameter is ignored and a vector of numerical predictions of the response
variable is returned.

For binary classification tasks, either
a vector of predicted responses is returned if type has the
value \code{response} (the default), or a vector of probabilities
for the positive class is returned, if type is \code{probability}.
You can also fetch the raw dataframe of prediction values using \code{raw}.

For multiclass classification tasks, \code{response} will return the predicted
class and \code{probability} will return the probability of each class.

This function will error if the requested job has errored, or
if it isn't complete within \code{maxWait} seconds.
}
\examples{
\dontrun{
  # Retrieve by predictJobID
  dataset <- UploadPredictionDataset(project, diamonds_small)
  model <- ListModels(project)[[1]]
  modelId <- model$modelId
  predictJobId <- RequestPredictions(project, modelId, dataset$id)
  predictions <- GetPredictions(project, predictJobId)
  # Retrieve by predictionID
  predictions <- ListPredictions(project)
  predictions <- GetPredictions(project, predictions$predictionId[[1]])
}
}
