% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_contradictions.R
\name{con_contradictions}
\alias{con_contradictions}
\title{Checks user-defined contradictions in study data}
\usage{
con_contradictions(
  resp_vars = NULL,
  study_data,
  label_col,
  item_level = "item_level",
  threshold_value,
  check_table,
  summarize_categories = FALSE,
  meta_data = item_level,
  meta_data_v2
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the measurement variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{threshold_value}{\link{numeric} from=0 to=100. a numerical value
ranging from 0-100}

\item{check_table}{\link{data.frame} contradiction rules table.  Table defining
contradictions. See details for
its required structure.}

\item{summarize_categories}{\link{logical} Needs a column 'tag' in the
\code{check_table}.
If set, a summary output is generated for the
defined categories plus one plot per
category.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}
}
\value{
If \code{summarize_categories} is \code{FALSE}:
A \link{list} with:
\itemize{
\item \code{FlaggedStudyData}: The first output of the contradiction function is a
data frame of similar dimension regarding the number
of observations in the study data. In addition, for
each applied check on the variables an additional
column is added which flags observations with a
contradiction given the applied check.
\item \code{SummaryTable}: The second output summarizes this information into one
data frame. This output can be used to provide an
executive overview on the amount of contradictions. This
output is meant for automatic digestion within pipelines.
\item \code{SummaryData}: The third output is the same as \code{SummaryTable} but for
human readers.
\item \code{SummaryPlot}: The fourth output visualizes summarized information
of \code{SummaryData}.
}

if \code{summarize_categories} is \code{TRUE}, other objects are returned:
one per category named by that category (e.g. "Empirical") containing a
result for contradictions within that category only. Additionally, in the
slot \code{all_checks} a result as it would have been returned with
\code{summarize_categories} set to \code{FALSE}. Finally, a slot \code{SummaryData} is
returned containing sums per Category and an according \link[ggplot2:ggplot]{ggplot2::ggplot} in
\code{SummaryPlot}.
}
\description{
This approach considers a contradiction if impossible combinations of data
are observed in one participant. For example, if age of a participant is
recorded repeatedly the value of age is (unfortunately) not able to decline.
Most cases of contradictions rest on comparison of two variables.

Important to note, each value that is used for comparison may represent a
possible characteristic but the combination of these two values is considered
to be impossible. The approach does not consider implausible or inadmissible
values.

\link{Descriptor}
}
\details{
\subsection{Algorithm of this implementation:}{
\itemize{
\item Select all variables in the data with defined contradiction rules (static
metadata column CONTRADICTIONS)
\item Remove missing codes from the study data (if defined in the metadata)
\item Remove measurements deviating from limits defined in the metadata
\item Assign label to levels of categorical variables (if applicable)
\item Apply contradiction checks on predefined sets of variables
\item Identification of measurements fulfilling contradiction rules. Therefore
two output data frames are generated:
\itemize{
\item on the level of observation to flag each contradictory value
combination, and
\item a summary table for each contradiction check.
}
\item A summary plot illustrating the number of contradictions is generated.
}

List function.
}
}
\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_con_impl_contradictions.html}{Online Documentation}
}
