% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_par_pmap.R
\name{util_par_pmap}
\alias{util_par_pmap}
\title{Utility function parallel version of \code{purrr::pmap}}
\usage{
util_par_pmap(
  .l,
  .f,
  ...,
  cores = list(mode = "socket", cpus = util_detect_cores(), logging = FALSE,
    load.balancing = TRUE),
  use_cache = FALSE
)
}
\arguments{
\item{.l}{\link{data.frame} with one call per line and one function argument
per column}

\item{.f}{\code{\link{function}} to call with the arguments from \code{.l}}

\item{...}{additional, static arguments for calling \code{.f}}

\item{cores}{number of cpu cores to use or a (named) list with arguments for
\link[parallelMap:parallelStart]{parallelMap::parallelStart} or NULL, if parallel has already
been started by the caller.}

\item{use_cache}{\link{logical} set to FALSE to omit re-using already distributed
study- and metadata on a parallel cluster}
}
\value{
\link{list} of results of the function calls
}
\description{
Parallel version of \code{purrr::pmap}.
}
\seealso{
\code{purrr::pmap}

\href{https://stackoverflow.com/a/47575143}{Stack Overflow post}

Other process_functions: 
\code{\link{util_abbreviate}()},
\code{\link{util_all_is_integer}()},
\code{\link{util_attach_attr}()},
\code{\link{util_bQuote}()},
\code{\link{util_backtickQuote}()},
\code{\link{util_coord_flip}()},
\code{\link{util_count_NA}()},
\code{\link{util_extract_matches}()},
\code{\link{util_setup_rstudio_job}()},
\code{\link{util_suppress_output}()}
}
\author{
\href{https://stackoverflow.com/users/6197649}{Aurèle}

S Struckmann
}
\concept{process_functions}
\concept{reporting}
\keyword{internal}
