% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/des_scatterplot_matrix.R
\name{des_scatterplot_matrix}
\alias{des_scatterplot_matrix}
\title{Compute Pairwise Correlations}
\usage{
des_scatterplot_matrix(
  study_data,
  meta_data,
  label_col = LABEL,
  meta_data_cross_item = "cross-item_level"
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{meta_data_cross_item}{\link{meta_data_cross}}
}
\value{
a \code{list} with the slots:
\itemize{
\item \code{SummaryPlotList}: for each variable group a \link{ggplot} object with
pairwise correlation plots
\item \code{SummaryData}: table with columns \code{VARIABLE_LIST}, \code{cors},
\code{max_cor}, \code{min_cor}
\item \code{SummaryTable}: like \code{SummaryData}, but machine readable and with
stable column names.
}
}
\description{
works on variable groups (\code{cross-item_level}), which are expected to show
a Pearson correlation
}
\details{
\link{Descriptor} # TODO: This can be an indicator
}
\examples{
\dontrun{
devtools::load_all()
prep_load_workbook_like_file("meta_data_v2")
des_scatterplot_matrix("study_data")
}
}
