% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descstat.r
\name{descstat}
\alias{descstat}
\title{Creates a descriptive statistics table for continuous
variables.}
\usage{
descstat(data = data, decnum = 3, eng = TRUE, full = FALSE)
}
\arguments{
\item{data}{a dataframe containing numeric variables as columns.}

\item{decnum}{the number of decimals to be used in the output. The
default is set to 3.}

\item{eng}{logical; if "TRUE" (by default), the language of the
statistics will be in English; if "FALSE" will be in Spanish.
descriptive statistics. The default is to "FALSE".}

\item{full}{logical; if "TRUE", the output includes some extra
descriptive statistics. The default is to "FALSE".}
}
\value{
This function wraps descriptive statistics into a
summarize table having the following statistics: sample size,
minimum, maximum, mean, median, SD, and coefficient of variation.
If the "full" option is set to "TRUE", the following
statistics will be added to the table: 25th and 75th
percentiles, the interquartile range, skewness, and kurtosis.
}
\description{
Function to create a descriptive statistics table for continuous
variables from a dataframe.
}
\details{
The resulting table offers the main central and dispersion
statistics.
}
\examples{

df <- datana::idahohd
head(df)
df.h<-df[,c("dbh","height")]
## using the function
descstat(data=df.h)
descstat(data=df.h,decnum=1,eng=FALSE)
descstat(df.h,2)
}
\references{
\itemize{
\item Salas-Eljatib C. 2021. Análisis de datos con el programa estadístico R:
una introducción aplicada. Ediciones Universidad Mayor. Santiago, Chile.
\url{https://eljatib.com}
}
}
\author{
Christian Salas-Eljatib and Tomas Cayul.
}
