% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{SftpLocation-class}
\alias{SftpLocation-class}
\alias{sftpdir}
\title{SFTP location}
\usage{
sftpdir(uri, pubkey, privatekey, keypasswd = "", clss = "SftpLocation")
}
\arguments{
\item{uri}{character, the address of the remote host in the form
sftp://username@the.host.com:port/remote/dir/}

\item{pubkey}{character, pointing to the public key file. Required.}

\item{privatekey}{character, pointing to the private key file. Required.}

\item{keypasswd}{character, optional key password}

\item{clss}{character, optional class name. Default is "SftpLocation".}
}
\description{
This class represents a directory on a remote server that is accessed
via the SFTP protocol. The only SSH authentication currently supported
the public RSA key method.

The sftpdir function creates a SftpLocation object.
}
\details{
The \code{show} and \code{as.character} methods for this class have been
adapted to reveal the URL of the directory it represents.

The \code{meta} method returns a \code{data.frame} with filenames and
an \code{is.dir} attribute. It currently returns wrong values when the
remote directory contains files with spaces in their file name.
}
\examples{
getSlots("SftpLocation")
}
\seealso{
\code{\link{sftpdir}}
}

