% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameColumns.R
\name{renameNWISColumns}
\alias{renameNWISColumns}
\title{renameColumns}
\usage{
renameNWISColumns(
  rawData,
  p00010 = "Wtemp",
  p00045 = "Precip",
  p00060 = "Flow",
  p00065 = "GH",
  p00095 = "SpecCond",
  p00300 = "DO",
  p00400 = "pH",
  p62611 = "GWL",
  p63680 = "Turb",
  p72019 = "WLBLS",
  ...
)
}
\arguments{
\item{rawData}{the daily- or unit-values datset retrieved from NWISweb.}

\item{p00010}{the base name for parameter code 00010.}

\item{p00045}{the base name for parameter code 00045.}

\item{p00060}{the base name for parameter code 00060.}

\item{p00065}{the base name for parameter code 00065.}

\item{p00095}{the base name for parameter code 00095.}

\item{p00300}{the base name for parameter code 00300.}

\item{p00400}{the base name for parameter code 00400.}

\item{p62611}{the base name for parameter code 62611.}

\item{p63680}{the base name for parameter code 63680.}

\item{p72019}{the base name for parameter code 72019.}

\item{\dots}{named arguments for the base name for any other parameter code. The
form of the name must be like pXXXXX, where XXXXX is the parameter code.}
}
\value{
A dataset like \code{data} with selected columns renamed.
}
\description{
Rename columns coming back from NWIS data retrievals.  Daily and unit value columns
have names derived from their data descriptor, parameter, and statistic codes. This
function reads information from the header and the arguments in the call to
to rename those columns.
}
\note{
The following statistics codes are converted by \code{renameNWISColumns}.
\describe{
\item{00000}{Instantaneous Value, suffix: Inst}
\item{00001}{Maximum value, suffix: Max}
\item{00002}{Minimum value, suffix: Min}
\item{00003}{Mean value, no suffix}
\item{00006}{Sum of values, suffix: Sum}
\item{00007}{Modal value, suffix: Mode}
\item{00008}{Median value, suffix: Median}
\item{00012}{Equivalent mean value, suffix: EqMean}
\item{00021}{Tidal high-high value, suffix: HiHiTide}
\item{00022}{Tidal low-high value, suffix: LoHiTide}
\item{00023}{Tidal high-low value, suffix: HiLoTide}
\item{00024}{Tidal low-low value, suffix: LoLoTide}
}
}
\examples{
siteWithTwo <- "01480015"
startDate <- "2012-09-01"
endDate <- "2012-10-01"
\donttest{
twoResults <- readNWISdv(siteWithTwo, "00060", startDate, endDate)
names(twoResults)
renamedCols <- renameNWISColumns(twoResults)
names(renamedCols)
# Custom names:
newNames <- renameNWISColumns(twoResults, p00060 = "Discharge")
names(newNames)
}
}
\seealso{
\code{\link{readNWISdv}}, \code{\link{readNWISuv}}
}
\keyword{IO}
\keyword{manip}
