% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getUserSample}
\alias{getUserSample}
\title{Import user sample data for EGRET analysis}
\usage{
getUserSample(filePath, fileName, hasHeader = TRUE, separator = ",",
  interactive = TRUE)
}
\arguments{
\item{filePath}{string specifying the path to the file}

\item{fileName}{string name of file to open}

\item{hasHeader}{logical true if the first row of data is the column headers}

\item{separator}{string character that separates data cells}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
Sample dataframe
}
\description{
Imports data from a user-supplied file, and converts it to a Sample data frame (including summing multiple constituents), appropriate for WRTDS calculations.
}
\examples{
filePath <- system.file("extdata", package="dataRetrieval")
filePath <- paste(filePath,"/",sep="")
fileName <- 'ChoptankRiverNitrate.csv'
Sample <- getUserSample(filePath,fileName, separator=";",interactive=FALSE)
}
\seealso{
\code{\link{compressData}}, \code{\link{populateSampleColumns}}
}
\keyword{data}
\keyword{file}
\keyword{import}

