% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setChecks.R
\name{setChecks}
\alias{setChecks}
\title{Set check arguments for makeDataReport}
\usage{
setChecks(character = defaultCharacterChecks(),
  factor = defaultFactorChecks(), labelled = defaultLabelledChecks(),
  haven_labelled = defaultHavenlabelledChecks(),
  numeric = defaultNumericChecks(), integer = defaultIntegerChecks(),
  logical = defaultLogicalChecks(), Date = defaultDateChecks(),
  all = NULL)
}
\arguments{
\item{character}{A character vector of function names to be used as checks for character
variables. The default options are available by calling \code{defaultCharacterChecks()}.}

\item{factor}{A character vector of function names to be used as checks for factor
variables. The default options are available by calling \code{defaultFactorChecks()}.}

\item{labelled}{A character vector of function names to be used as checks for labelled
variables. The default options are available by calling \code{defaultLabelledChecks()}.}

\item{haven_labelled}{A character vector of function names to be used as checks for haven_labelled
variables. The default options are available by calling \code{defaultHavenlabelledChecks()}.}

\item{numeric}{A character vector of function names to be used as checks for numeric
variables. The default options are available by calling \code{defaultNumericChecks()}.}

\item{integer}{A character vector of function names to be used as checks for integer
variables. The default options are available by calling \code{defaultIntegerChecks()}.}

\item{logical}{A character vector of function names to be used as checks for logical
variables. The default options are available by calling \code{defaultLogicalChecks()}.}

\item{Date}{A character vector of function names to be used as checks for Date
variables. The default options are available by calling \code{defaultDateChecks()}.}

\item{all}{A character vector of function names to be used as checks for all
variables. Note that this overrules the choices made for specific variable types by using
the other arguments.}
}
\value{
A list with one entry for each data class supported by \code{makeDataReport}. Each
entry then contains a character vector of function names that are to be called as checks for
that variable type.
}
\description{
This function is a tool for easily specifying the \code{checks} argument of 
\code{\link{makeDataReport}}. Note that all available check function options can be inspected
by calling \code{allCheckFunctions()}.
}
\examples{
#Only identify missing values for characters, logicals and labelled variables:
  setChecks(character = "identifyMissing", factor = "identifyMissing", 
     labelled = "identifyMissing")
     
#Used in a call to makeDataReport():
\dontrun{
data(toyData)
makeDataReport(toyData, checks = setChecks(character = "identifyMissing", 
   factor = "identifyMissing", labelled = "identifyMissing"), replace = TRUE)
}
     
}
\seealso{
\code{\link{makeDataReport}}, \code{\link{allCheckFunctions}},
\code{\link{defaultCharacterChecks}}, 
\code{\link{defaultFactorChecks}}, \code{\link{defaultLabelledChecks}},
\code{\link{defaultHavenlabelledChecks}},
\code{\link{defaultNumericChecks}}, \code{\link{defaultIntegerChecks}},
\code{\link{defaultLogicalChecks}}, \code{\link{defaultDateChecks}}
}
