% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sim.WF.run.r
\name{gl.sim.WF.run}
\alias{gl.sim.WF.run}
\title{Runs Wright-Fisher simulations}
\usage{
gl.sim.WF.run(
  file_var,
  ref_table,
  x = NULL,
  file_dispersal = NULL,
  number_iterations = 1,
  every_gen = 10,
  sample_percent = 50,
  store_phase1 = FALSE,
  interactive_vars = TRUE,
  seed = NULL,
  verbose = NULL,
  ...
)
}
\arguments{
\item{file_var}{Path of the variables file 'sim_variables.csv' (see details) 
[required if interactive_vars = FALSE].}

\item{ref_table}{Reference table created by the function 
\code{\link{gl.sim.WF.table}} [required].}

\item{x}{Name of the genlight object containing the SNP data to extract
values for some simulation variables (see details) [default NULL].}

\item{file_dispersal}{Path of the file with the dispersal table created with
the function \code{\link{gl.sim.create_dispersal}} [default NULL].}

\item{number_iterations}{Number of iterations of the simulations [default 1].}

\item{every_gen}{Generation interval at which simulations should be stored in
a genlight object [default 10].}

\item{sample_percent}{Percentage of individuals, from the total population, 
to sample and save in the genlight object every generation [default 50].}

\item{store_phase1}{Whether to store simulations of phase 1 in genlight
objects [default FALSE].}

\item{interactive_vars}{Run a shiny app to input interactively the values of
simulations variables [default TRUE].}

\item{seed}{Set the seed for the simulations [default NULL].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}

\item{...}{Any variable and its value can be added separately within the 
function, will be changed over the input value supplied by the csv file. See 
tutorial.}
}
\value{
Returns genlight objects with simulated data.
}
\description{
This function simulates populations made up of diploid organisms that 
reproduce in non-overlapping generations. Each individual has a pair of 
homologous chromosomes that contains interspersed selected and neutral loci. 
For the initial generation, the genotype for each individual’s chromosomes is
 randomly drawn from distributions at linkage equilibrium and in 
 Hardy-Weinberg equilibrium. 

See documentation and tutorial for a complete description of the simulations.
These documents can be accessed at http://georges.biomatix.org/dartR 

Take into account that the simulations will take a little bit longer the
 first time you use the function gl.sim.WF.run() because C++ functions must
  be compiled.
}
\details{
Values for simulation variables can be submitted into the function 
interactively through a shiny app if interactive_vars = TRUE. Optionally, if 
interactive_vars = FALSE, values for variables can be submitted by using the
csv file 'sim_variables.csv' which can be found by typing in the R console:
 system.file('extdata', 'sim_variables.csv', package ='dartR').
 
The values of the variables can be modified using the third column (“value”) 
of this file. 

The output of the simulations can be analysed seemingly with other dartR 
functions.

If a genlight object is used as input for some of the simulation variables, 
this function access the information stored in the slots x$position and 
x$chromosome.

To show further information of the variables in interactive mode, it might be
 necessary to call first: 'library(shinyBS)' for the information to be 
 displayed.

The main characteristics of the simulations are:
\itemize{ 
\item Simulations can be parameterised with real-life genetic 
characteristics such as the number, location, allele frequency and the 
distribution of fitness effects (selection coefficients and dominance) of 
loci under selection. 
\item Simulations can recreate specific life histories and demographics, such
 as source populations, dispersal rate, number of generations, founder 
 individuals, effective population size and census population size.
\item Each allele in each individual is an agent (i.e., each allele is 
explicitly simulated).
\item Each locus can be customisable regarding its allele frequencies, 
selection coefficients, and dominance.
\item The number of loci, individuals, and populations to be simulated is 
only limited by computing resources.
\item Recombination is accurately modeled, and it is possible to use real 
recombination maps as input.
\item The ratio between effective population size and census population size 
can be easily controlled.
\item The output of the simulations are genlight objects for each generation 
or a subset of generations.
\item Genlight objects can be used as input for some simulation variables.
}
}
\examples{
\dontrun{
ref_table <- gl.sim.WF.table(file_var=system.file('extdata', 
'ref_variables.csv', package = 'dartR'),interactive_vars = FALSE)
res_sim <- gl.sim.WF.run(file_var = system.file('extdata', 
'sim_variables.csv', package ='dartR'),ref_table=ref_table,
interactive_vars = FALSE)
}
}
\seealso{
\code{\link{gl.sim.WF.table}}

Other simulation functions: 
\code{\link{gl.sim.WF.table}()},
\code{\link{gl.sim.create_dispersal}()}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{simulation functions}
