% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.keep.ind.r
\name{gl.keep.ind}
\alias{gl.keep.ind}
\title{Remove all but the specified individuals from a genelight \{adegenet\} object}
\usage{
gl.keep.ind(x, ind.list, recalc = FALSE, mono.rm = FALSE, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing SNP genotypes or a genind object containing presence/absence data [required]}

\item{ind.list}{-- a list of individuals to be removed [required]}

\item{recalc}{-- Recalculate the locus metadata statistics [default FALSE]}

\item{mono.rm}{-- Remove monomorphic loci [default FALSE]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
A genlight object with the reduced data
}
\description{
The script, having deleted individuals, optionally identifies resultant monomorphic loci or loci
with all values missing and deletes them (using gl.filter.monomorphs.r). The script also optionally
recalculates statistics made redundant by the deletion of individuals from the dataset.
}
\details{
The script returns a genlight object with the individuals deleted and, optionally, the recalculated locus metadata.
}
\examples{
  # SNP data
    gl2 <- gl.keep.ind(testset.gl, ind.list=c("AA019073","AA004859"))
  # Tag P/A data
   gs2 <- gl.keep.ind(testset.gs, ind.list=c("AA020656","AA19077","AA004859"))
   
}
\seealso{
\code{\link{gl.filter.monomorphs}} for when mono.rm=TRUE, \code{\link{gl.recalc.metrics}} for when recalc=TRUE

\code{\link{gl.drop.ind}} to drop rather than keep specified individuals
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
