% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.reset.flags.r
\name{utils.reset.flags}
\alias{utils.reset.flags}
\title{A utility script to reset to FALSE (or TRUE) the locus metric flags after some individuals or populations have been deleted.}
\usage{
utils.reset.flags(x, set = FALSE, value = 2, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data or tag presence/absence data (SilicoDArT) [required]}

\item{set}{-- set the flags to TRUE or FALSE [FALSE]}

\item{value}{-- set the default verbosity for all functions, where verbosity is not specified}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default NULL]}
}
\value{
The modified genlight object
}
\description{
The locus metadata supplied by DArT has OneRatioRef, OneRatioSnp, PICRef, PICSnp, and AvgPIC included,
but the allelec composition will change when some individuals are removed from the dataset and so the initial statistics will
no longer apply. This applies also to some variable calculated by dartR (e.g. maf). This script resets the locus metrics
flags to FALSE to indicate that these statistics in the genlight object are no longer current. The verbosity default is also set, and
in the case of SilcoDArT, the flags PIC and OneRatio are also set.
}
\details{
If the locus metrics do not exist then they are added to the genlight object but not populated. If the locus metrics flags 
do not exist, then they are added to the genlight object and set to FALSE (or TRUE).
}
\examples{
#result <- utils.reset.flags(testset.gl)
}
\seealso{
\code{utils.recalc.metrics} for recalculating all metrics, \code{utils.recalc.callrate} for recalculating CallRate,
\code{utils.recalc.freqhomref} for recalculating frequency of homozygous reference, \code{utils.recalc.freqhomsnp} for recalculating frequency of homozygous alternate,
\code{utils.recalc.freqhet} for recalculating frequency of heterozygotes, \code{gl.recalc.maf} for recalculating minor allele frequency,
\code{gl.recalc.rdepth} for recalculating average read depth
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
