% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.hwe.pop.r
\name{gl.hwe.pop}
\alias{gl.hwe.pop}
\title{Filter function to facilitate analysing of dart data}
\usage{
gl.hwe.pop(gi, pvalue = 0.05, plot = TRUE)
}
\arguments{
\item{gi}{a genlight or genind object(genlight is internally converted to genind)}

\item{pvalue}{the p-value for the HWE test.}

\item{plot}{a switch if a barplot is wanted.}
}
\value{
This functions performs a HWE test for every population (rows) and loci (columns) and returns a true false matrix. True is reported if the p-value of an HWE-test for a particular loci and population was below the specified threshold (pvalue, default=0.05). The thinking behind this approach is that loci that are not in HWE in several populations have most likely to be treated (e.g. filtered if loci under selection are of interest). If plot=TRUE a barplot on the on the loci and the sum of deviation over all population is returned. Loci that deviate in the majority of populations can be identified via colSums on the resulting matrix.
}
\description{
Filter function to facilitate analysing of dart data
}
\examples{
\dontrun{
gl.hwe.pop(gi=gi, pvalue = 0.05, plot = TRUE)
}
}
