% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.collapse.r
\name{gl.collapse}
\alias{gl.collapse}
\title{Collapse a distance matrix by amalgamating populations}
\usage{
gl.collapse(fd, recode.table = "tmp.csv", tpop = 0, tloc = 0, v = 2)
}
\arguments{
\item{fd}{-- name of the list of matricies produced by gl.fixed.diff() [required]}

\item{recode.table}{-- name of the new recode.table to receive the new population reassignments 
arising from the amalgamation of populations [default tmp.csv]}

\item{tpop}{-- max number of fixed differences used amalgamating populations [default 0]}

\item{tloc}{-- threshold defining a fixed difference (e.g. 0.05 implies 95:5 vs 5:95 is fixed) [default 0]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
A list containing the gl object x and the following square matricies
        [[1]] $gl -- the new genlight object with populations collapsed;
        [[2]] $fd -- raw fixed differences;
        [[3]] $pcfd -- percent fixed differences;
        [[4]] $nobs -- mean no. of individuals used in each comparison;
        [[5]] $nloc -- total number of loci used in each comparison;
        [[6]] $expobs -- if test=TRUE, the expected count of false positives for each comparison [by simulation];
        [[7]] $prob -- if test=TRUE, the significance of the count of fixed differences [by simulation])
}
\description{
This script takes a the file generated by gl.fixed.diff and generates a population recode
table to amalgamate populations with distance less than or equal to a specified threshold
The distance matrix is generated by gl.fixed.diff()
}
\details{
The script then applies the recode to the genlight object and recalculates the distance and associated matricies.
}
\examples{
\donttest{
fd <- gl.fixed.diff(testset.gl, tloc=0.05)
gl <- gl.collapse(fd, recode.table="testset_recode.csv",tpop=1)
}
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
