% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_inactive_periods.R
\name{detect_inactive_periods}
\alias{detect_inactive_periods}
\title{Detect inactive periods}
\usage{
detect_inactive_periods(
  activitylog,
  threshold,
  type,
  timestamp,
  start_activities,
  details,
  filter_condition
)
}
\arguments{
\item{activitylog}{The activity log}

\item{threshold}{Threshold after which a period without activity executions/arrivals is considered as an inactive period (expressed in minutes)}

\item{type}{Type of inactive periods you want to detect. "arrivals" will look for periods without new cases arriving. "activities" will look for periods where no activities occur.}

\item{timestamp}{Type of timestamp that needs to be taken into account in the analysis (either "start", "complete" or "both)}

\item{start_activities}{List of activity labels marking the first activity in the process. When specified, an inactive period only occurs when the time between two consecutive arrivals exceeds the specified threshold (arrival is proxied by the activity/activities specified in this argument).}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
tbl_df providing an overview of the start and end of the inactive periods that have been detected, together with the length of the inactive period
}
\description{
Function detecting inactive periods, i.e. periods of time in which no activity executions/arrivals are recorded in the activity log
}
\examples{
\donttest{
data("hospital_actlog")
detect_inactive_periods(activitylog = hospital_actlog,threshold = 30)
}
}
