% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_attribute_dependency_violations.R
\name{detect_attribute_dependencies}
\alias{detect_attribute_dependencies}
\title{Detect dependency violations between attributes}
\usage{
detect_attribute_dependencies(
  activitylog,
  antecedent,
  consequent,
  details = TRUE,
  filter_condition = NULL,
  ...
)
}
\arguments{
\item{activitylog}{The activity log}

\item{antecedent}{(Vector of) condition(s) which serve as an antecedent (if the condition(s) in antecedent hold, then the condition(s) in consequent should also hold)}

\item{consequent}{(Vector of) condition(s) which serve as a consequent (if the condition(s) in antecedent hold, then the condition(s) in consequent should also hold)}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}

\item{...}{Named vectors with name of the activity, and value of the threshold.}
}
\value{
activitylog containing the rows of the original activity log for which the dependencies between attributes are violated
}
\description{
Function detecting violations of dependencies between attributes (i.e. condition(s) that should hold when (an)other condition(s) hold(s))
}
\examples{
\donttest{
data("hospital_actlog")
detect_attribute_dependencies(activitylog = hospital_actlog,
     antecedent = activity == "Registration",
     consequent = startsWith(originator,"Clerk"))
}
}
