% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_gminmax.R
\name{ts_norm_gminmax}
\alias{ts_norm_gminmax}
\title{Time Series Global Min-Max}
\usage{
ts_norm_gminmax(remove_outliers = TRUE)
}
\arguments{
\item{remove_outliers}{logical: if TRUE (default) outliers will be removed.}
}
\value{
a \code{ts_norm_gminmax} object.
}
\description{
Rescales data, so the minimum value is mapped to 0 and the maximum value is mapped to 1.
}
\examples{
# time series to normalize
data(sin_data)

# convert to sliding windows
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# normalization
preproc <- ts_norm_gminmax()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
