% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward.R
\name{forward}
\alias{forward}
\title{Infer the forward probabilities for all the nodes of the dagHMM}
\usage{
forward(hmm, observation, ft_seq, kn_states = NULL)
}
\arguments{
\item{hmm}{hmm Object of class List given as output by \code{\link{initHMM}}}

\item{observation}{Dataframe containing the discritized character values of only covariates at each node. Column names of dataframe should be same as the covariate names. Missing values should be denoted by "NA".}

\item{ft_seq}{A vector denoting the order of nodes in which the DAG should be traversed in forward direction(from roots to leaves). Output of \code{\link{fwd_seq_gen}} function.}

\item{kn_states}{(Optional) A (L * 2) dataframe where L is the number of training nodes where state values are known. First column should be the node number and the second column being the corresponding known state values of the nodes}
}
\value{
(2 * N) matrix denoting the forward probabilites at each node of the dag, where "N" is the total number of nodes in the dag
}
\description{
\code{forward} calculates the forward probabilities for all the nodes
}
\details{
The forward probability for state X up to observation at node k is defined as the probability of observing the sequence of observations e_1,..,e_k given that the state at node k is X.
That is:\cr\code{f[X,k] := Prob( X_k = X | E_1 = e_1,.., E_k = e_k)}
\cr where \code{E_1...E_n = e_1...e_n} is the sequence of observed emissions and \code{X_k} is a random variable that represents the state at node \code{k}
}
\examples{

library(bnlearn)

tmat = matrix(c(0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0),
               5,5, byrow= TRUE ) #for "X" (5 nodes) shaped dag
states = c("P","N") #"P" represent cases(or positive) and "N" represent controls(or negative)
bnet = model2network("[A][C|A:B][D|A:C][B|A]") #A is the target variable while
                                               #B, C and D are covariates
obsvA=data.frame(list(B=c("L","H","H","L","L"),C=c("H","H","L","L","H"),D=c("L","L","L","H","H")))
hmmA = initHMM(States=states, dagmat= tmat, net=bnet, observation=obsvA)
ft_sq = fwd_seq_gen(hmmA)
kn_st = data.frame(node=c(3),state=c("P"),stringsAsFactors = FALSE)
                   #state at node 3 is known to be "P"
ForwardProbs = forward(hmm=hmmA,observation=obsvA,ft_seq=ft_sq,kn_states=kn_st)
}
\seealso{
\code{\link{backward}}
}
