% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge-data.R
\name{merge_data}
\alias{merge_data}
\title{Merge two tables based on a parent version}
\usage{
merge_data(parent, a, b)
}
\arguments{
\item{parent}{\code{data.frame}}

\item{a}{\code{data.frame} changed version of \code{parent}}

\item{b}{\code{data.frame} other changed version of \code{parent}}
}
\value{
merged \code{data.frame}. When a merge has conflicts the columns of conflicting changes
are of type \code{character} and contain all three values.
}
\description{
\code{merge_data} provides a three-way merge: suppose two versions are based on a common
version, this function will merge tables \code{a} and \code{b}.
}
\details{
If both \code{a} and \code{b} change the same table cell with a different value, this results in a
conflict. In that case a warning will be generated with the number of conflicts.
In the returned \code{data.frame} of a conflicting merge columns with conflicting values are of type
\code{character} and contain all three values coded as

(parent) a /// b
}
\examples{
parent <- a <- b <- iris[1:3,]
a[1,1] <- 10
b[2,1] <- 11
# succesful merge
merge_data(parent, a, b)

parent <- a <- b <- iris[1:3,]
a[1,1] <- 10
b[1,1] <- 11
# conflicting merge (both a and b change same cell)
merged <- merge_data(parent, a, b)
merged #note the conflict

#find out which rows contain a conflict
which_conflicts(merged)
}
\seealso{
\code{\link{which_conflicts}}
}
