% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff-data.R
\name{diff_data}
\alias{diff_data}
\title{Do a data diff}
\usage{
diff_data(data_ref, data, ids = NULL, ignore = NULL, context = 1L,
  show_all = FALSE)
}
\arguments{
\item{data_ref}{\code{data.frame} reference data frame}

\item{data}{\code{data.frame} to check for changes}

\item{ids}{\code{character} identification columns (not yet working)}

\item{ignore}{\code{character} columns to ignore (not yet working)}

\item{context}{\code{integer} number of context rows (not yet working)}

\item{show_all}{\code{logical} show all rows or only changed rows?  (not yet working)}
}
\value{
difference object
}
\description{
Find differences with a reference data set. The diff can be used to \code{\link{patch_data}}, to store the difference
for documentation purposes using \code{\link{write_diff}} or to visualize the difference using \code{\link{render_diff}}
}
\examples{
library(daff)
x <- iris
x[1,1] <- 10
diff_data(x, iris)

dd <- diff_data(x, iris)
#write_diff(dd, "diff.csv")
}
\seealso{
differs_from
}

