% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.quantification_and_export.R
\name{target_quant}
\alias{target_quant}
\title{Calculation of targets concentration.}
\usage{
target_quant(data.cluster, sample.table)
}
\arguments{
\item{data.cluster}{an object of class \code{rain_reclus} or
\code{cmeans_clus}.}

\item{sample.table}{object of class \code{sample_table}, inherited from
\code{\link{read_sampleTable}}.}
}
\value{
An object of class \code{target_quant} containing a sublist for
  each sample. Each sublist has the following components:
  \item{quality}{quality threshold used in \code{\link{read_sample}}.}
  \item{reference}{reference ID.}
  \item{raw results}{a data frame with the results of the quantification.}
}
\description{
This function calculates the concentration of the targets according to the
Poisson distribution.
}
\examples{
\donttest{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata", package = "dPCP")

#Read sample table file
sample.table <- read_sampleTable(sampleTable, system = "bio-rad",
                                 file.location = fileLoc)

#Read reference files
ref <- read_reference(sample.table, system = "bio-rad",
                      file.location = fileLoc)

#Read samples files
samp <- read_sample(sample.table, system = "bio-rad",
                    file.location = fileLoc)

#Reference DBSCAN clustering
dbref <- reference_dbscan(ref, sample.table, save.template = FALSE)

#Predict position of clusters centroid from reference DBSCAN results
cent <- centers_data(samp, sample.table,dbref)

#Fuzzy c-means clustering
cmclus <- cmeans_clus(cent)

#Rain classification.
rainclus <- rain_reclus(cmclus)

#Quantification
quantcm <- target_quant(cmclus, sample.table)
quant <- target_quant(rainclus, sample.table)
}
}
