% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_probabilities.R
\name{plot_probabilities}
\alias{plot_probabilities}
\title{Plot predicted probabilities}
\usage{
plot_probabilities(
  data,
  target_col,
  probability_cols,
  predicted_class_col = NULL,
  obs_id_col = NULL,
  group_col = NULL,
  probability_of = "target",
  positive = 2,
  order = "centered",
  theme_fn = ggplot2::theme_minimal,
  color_scale = ggplot2::scale_colour_brewer(palette = "Dark2"),
  apply_facet = length(probability_cols) > 1,
  smoothe = FALSE,
  add_points = !is.null(obs_id_col),
  add_hlines = TRUE,
  add_caption = TRUE,
  show_x_scale = FALSE,
  line_settings = list(),
  smoothe_settings = list(),
  point_settings = list(),
  hline_settings = list(),
  facet_settings = list(),
  ylim = c(0, 1)
)
}
\arguments{
\item{data}{\code{data.frame} with probabilities, target classes and (optional) predicted classes.
 Can also include observation identifiers and a grouping variable.

 Example for binary classification:

 \tabular{rrrrr}{
  \strong{Classifier} \tab \strong{Observation} \tab \strong{Probability} \tab \strong{Target} \tab \strong{Prediction}  \cr
  SVM \tab 1 \tab 0.3 \tab cl_1 \tab cl_1 \cr
  SVM \tab 2 \tab 0.7 \tab cl_1 \tab cl_2 \cr
  NB \tab 1 \tab 0.2 \tab cl_2 \tab cl_1 \cr
  NB \tab 2 \tab 0.8 \tab cl_2 \tab cl_2 \cr
  ... \tab ... \tab ... \tab ... \tab ... \cr
 }

 Example for multiclass classification:

 \tabular{rrrrrrr}{
  \strong{Classifier} \tab \strong{Observation} \tab \strong{cl_1} \tab \strong{cl_2} \tab \strong{cl_3} \tab \strong{Target} \tab \strong{Prediction}  \cr
  SVM \tab 1 \tab 0.2 \tab 0.1 \tab 0.7 \tab cl_1 \tab cl_3 \cr
  SVM \tab 2 \tab 0.3 \tab 0.5 \tab 0.2 \tab cl_1 \tab cl_2 \cr
  NB \tab 1 \tab 0.8 \tab 0.1 \tab 0.1 \tab cl_2 \tab cl_1 \cr
  NB \tab 2 \tab 0.1 \tab 0.6 \tab 0.3 \tab cl_3 \tab cl_2 \cr
  ... \tab ... \tab ... \tab ... \tab ... \tab ... \tab ... \cr
 }

 You can have multiple rows per observation ID per group. If, for instance, we
 have run repeated cross-validation of 3 classifiers, we would have one predicted probability
 per fold column per classifier.

 As created with the various validation functions in \code{cvms}, like
 \code{\link[cvms:cross_validate_fn]{cross_validate_fn()}}.}

\item{target_col}{Name of column with target levels.}

\item{probability_cols}{Name of columns with predicted probabilities.

 For \strong{binary} classification, this should be \strong{one column} with the probability of the
 \strong{second class} (alphabetically).

 For \strong{multiclass} classification, this should be \strong{one column per class}.
 These probabilities must sum to \code{1} row-wise.}

\item{predicted_class_col}{Name of column with predicted classes.

 This is required when \code{probability_of = "prediction"} and/or \code{add_hlines = TRUE}.}

\item{obs_id_col}{Name of column with observation identifiers for grouping the \strong{x-axis}.
 When \code{NULL}, each row is an observation.

 Use case: when you have multiple predicted probabilities per observation by a classifier
 (e.g. from repeated cross-validation).

 Can also be a grouping variable that you wish to aggregate.}

\item{group_col}{Name of column with groups. The plot elements
 are split by these groups and can be identified by their color.

 E.g. the \emph{classifier} responsible for the prediction.

 \strong{N.B.} With more than \strong{\code{8}} groups,
 the default \code{`color_scale`} might run out of colors.}

\item{probability_of}{Whether to plot the probabilities of the
 target classes (\code{"target"}) or the predicted classes (\code{"prediction"}).

 For each row, we extract the probability of either the
 \emph{target class} or the \emph{predicted class}. Both are useful
 to plot, as they show the behavior of the classifier in a way a confusion matrix doesn't.
 One classifier might be very certain in its predictions (whether wrong or right), whereas
 another might be less certain.}

\item{positive}{TODO}

\item{order}{How to order of the the probabilities. (Character)

  One of: \code{"descending"}, \code{"ascending"}, and \code{"centered"}.}

\item{theme_fn}{The \code{ggplot2} theme function to apply.}

\item{color_scale}{\code{ggplot2} color scale object for adding discrete colors to the plot.

 E.g. the output of
 \code{\link[ggplot2:scale_colour_brewer]{ggplot2::scale_colour_brewer()}} or
 \code{\link[ggplot2:scale_colour_viridis_d]{ggplot2::scale_colour_viridis_d()}}.

 \strong{N.B.} The number of colors in the object's palette should be at least the same as
 the number of groups in the \code{`group_col`} column.}

\item{apply_facet}{Whether to use
 \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}. (Logical)

 By default, faceting is applied when there are more than one probability column (multiclass).}

\item{smoothe}{Whether to use \code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}} instead of
 \code{\link[ggplot2:geom_line]{ggplot2::geom_line()}}.
 This also adds a \code{95\%} confidence interval by default.

 Settings can be passed via the \code{`smoothe_settings`} argument.}

\item{add_points}{Add a point for each predicted probability.
These are grouped on the x-axis by the \code{`obs_id_col`} column. (Logical)}

\item{add_hlines}{Add horizontal lines. (Logical)

 The meaning of these lines depends on the \code{`probability_of`}
 and \code{`apply_facet`} arguments:

 \tabular{rrr}{
  \strong{\code{apply_facet}} \tab \strong{\code{probability_of}} \tab \strong{Metric} \cr
  \code{FALSE} \tab \code{"target"} \tab \strong{Accuracy} \cr
  \code{FALSE} \tab \code{"prediction"} \tab \strong{Accuracy} \cr
  \code{TRUE} \tab \code{"target"} \tab \strong{Recall / Sensitivity} \cr
  \code{TRUE} \tab \code{"prediction"} \tab \strong{Precision / PPV} \cr
 }}

\item{add_caption}{Whether to add a caption explaining the plot. This is dynamically generated
 and intended as a starting point. (Logical)

 You can overwrite the text with \code{ggplot2::labs(caption = "...")}.}

\item{show_x_scale}{TODO}

\item{line_settings}{Named list of arguments for \code{\link[ggplot2:geom_line]{ggplot2::geom_line()}}.

  The \code{mapping} argument is set separately.

  Any argument not in the list will use its default value.

  Default: \code{list(size = 0.5)}

  \strong{N.B.} Ignored when \code{smoothe = TRUE}.}

\item{smoothe_settings}{Named list of arguments for \code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}}.

  The \code{mapping} argument is set separately.

  Any argument not in the list will use its default value.

  Default: \code{list(size = 0.5, alpha = 0.18, level = 0.95, se = TRUE)}

  \strong{N.B.} Only used when \code{smoothe = TRUE}.}

\item{point_settings}{Named list of arguments for \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.

  The \code{mapping} argument is set separately.

  Any argument not in the list will use its default value.

  Default: \code{list(size = 0.1, alpha = 0.4)}}

\item{hline_settings}{Named list of arguments for \code{\link[ggplot2:geom_hline]{ggplot2::geom_hline()}}.

  The \code{mapping} argument is set separately.

  Any argument not in the list will use its default value.

  Default: \code{list(size = 0.35, alpha = 0.5)}}

\item{facet_settings}{Named list of arguments for \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.

  The \code{facets} argument is set separately.

  Any argument not in the list will use its default value.

  Commonly set arguments are \code{nrow} and \code{ncol}.}

\item{ylim}{Limits for the y-scale.}
}
\value{
A \code{ggplot2} object with a faceted line plot. TODO
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Creates a \code{\link[ggplot2:ggplot]{ggplot2}} line plot object with the probabilities
 of either the target classes or the predicted classes.

 The observations are ordered by the highest probability.

 TODO line geom: average probability per observation

 TODO points geom: actual probabilities per observation

 The meaning of the \strong{horizontal lines} depend on the settings.
 These are either \emph{recall} scores, \emph{precision} scores,
 or \emph{accuracy} scores, depending on the \code{`probability_of`}
 and \code{`apply_facet`} arguments.
}
\details{
TODO
}
\examples{
\donttest{
# Attach cvms
library(cvms)
library(ggplot2)
library(dplyr)

#
# Multiclass
#

# Plot probabilities of target classes
# From repeated cross-validation of three classifiers

# plot_probabilities(
#   data = predicted.musicians,
#   target_col = "Target",
#   probability_cols = c("A", "B", "C", "D"),
#   predicted_class_col = "Predicted Class",
#   group_col = "Classifier",
#   obs_id_col = "ID",
#   probability_of = "target"
# )

# Plot probabilities of predicted classes
# From repeated cross-validation of three classifiers

# plot_probabilities(
#   data = predicted.musicians,
#   target_col = "Target",
#   probability_cols = c("A", "B", "C", "D"),
#   predicted_class_col = "Predicted Class",
#   group_col = "Classifier",
#   obs_id_col = "ID",
#   probability_of = "prediction"
# )

# Center probabilities

# plot_probabilities(
#   data = predicted.musicians,
#   target_col = "Target",
#   probability_cols = c("A", "B", "C", "D"),
#   predicted_class_col = "Predicted Class",
#   group_col = "Classifier",
#   obs_id_col = "ID",
#   probability_of = "prediction",
#   order = "centered"
# )

#
# Binary
#

# Filter the predicted.musicians dataset
# binom_data <- predicted.musicians \%>\%
#   dplyr::filter(
#     Target \%in\% c("A", "B")
#   ) \%>\%
#   # "B" is the second class alphabetically
#   dplyr::rename(Probability = B) \%>\%
#   dplyr::mutate(`Predicted Class` = ifelse(
#     Probability > 0.5, "B", "A")) \%>\%
#   dplyr::select(-dplyr::all_of(c("A","C","D")))

# Plot probabilities of predicted classes
# From repeated cross-validation of three classifiers

# plot_probabilities(
#   data = binom_data,
#   target_col = "Target",
#   probability_cols = "Probability",
#   predicted_class_col = "Predicted Class",
#   group_col = "Classifier",
#   obs_id_col = "ID",
#   probability_of = "target"
# )

# plot_probabilities(
#   data = binom_data,
#   target_col = "Target",
#   probability_cols = "Probability",
#   predicted_class_col = "Predicted Class",
#   group_col = "Classifier",
#   obs_id_col = "ID",
#   probability_of = "prediction",
#   ylim = c(0.5, 1)
# )

}
}
\seealso{
Other plotting functions: 
\code{\link{font}()},
\code{\link{plot_confusion_matrix}()},
\code{\link{plot_metric_density}()},
\code{\link{plot_probabilities_ecdf}()},
\code{\link{sum_tile_settings}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{plotting functions}
\keyword{internal}
