% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelspec.R
\name{modelspec}
\alias{modelspec}
\title{Generate non-nested candidate models}
\usage{
modelspec(nump, numq)
}
\arguments{
\item{nump}{The number of scalar predictors used in candidate models.}

\item{numq}{The number of functional principal components (FPCs) used in candidate models.}
}
\value{
A \code{list} of
    \item{a1}{The number of scalar predictors in each candidate model.}
    \item{a2}{The number of FPCs in each candidate model.}
    \item{a3}{The index for each component in each candidate model.}
}
\description{
Specify non-nested candidate models, according to the prescribed number of scalar predictors and the number of functional principal components (FPCs).
     Each candidate model comprises at least one scalar predictor and one FPC, leading to a total number of candidate models \emph{(2^\code{nump}-1)*(2^\code{numq}-1)}.
}
\examples{
# Given nump = 2 and numq = 2, resulting in 9 candidate models
modelspec(2, 2)
#$a1
#[1] 2 2 2 1 1 1 1 1 1
#$a2
#[1] 2 1 1 2 1 1 2 1 1
#$a3
#      [,1] [,2] [,3] [,4]
# [1,]    1    2    3    4
# [2,]    1    2    3    0
# [3,]    1    2    0    4
# [4,]    1    0    3    4
# [5,]    1    0    3    0
# [6,]    1    0    0    4
# [7,]    0    2    3    4
# [8,]    0    2    3    0
# [9,]    0    2    0    4

}
