% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ComputeMLE}
\alias{ComputeMLE}
\title{Maximum Likelihood Estimator}
\usage{
ComputeMLE(data)
}
\arguments{
\item{data}{Dataframe with three variables:
\describe{
    \item{t}{Observation points t sorted in ascending order. All observations need to be positive. The total number of unique observation points equals \code{length(t)}.}
    \item{freq1}{Frequency of observation t satisfying \eqn{x \le t}.
                  The total number of observations with censoring indicator \eqn{\delta =1} equals \code{sum(freq1)}. }
    \item{freq2}{Frequency of observation t. The sample size equals \code{sum(freq2)}. If no tied observations are present in the data \code{length(t)} equals \code{sum(freq2)}. }
}}
}
\value{
Dataframe with two variables :
\describe{
    \item{x}{jump locations of the MLE}
    \item{mle}{MLE evaluated at the jump locations}
}
}
\description{
The function ComputeMLE computes the Maximum Likelihood Estimator of the distribution function under current status data.
}
\details{
In the current status model, the variable of interest \eqn{X} with distribution function \eqn{F} is not observed directly.
A censoring variable \eqn{T} is observed instead together with the indicator \eqn{\Delta = (X \le T)}.
ComputeMLE computes the MLE of \eqn{F} based on a sample of size \code{n <- sum(data$freq2)}.
}
\examples{
library(Rcpp)
library(curstatCI)

# sample size
n <- 1000

# Uniform data  U(0,2)
set.seed(2)
y <- runif(n,0,2)
t <- runif(n,0,2)
delta <- as.numeric(y <= t)

A<-cbind(t[order(t)], delta[order(t)], rep(1,n))
mle <-ComputeMLE(A)
plot(mle$x, mle$mle,type ='s', ylim=c(0,1), main= "",ylab="",xlab="",las=1)

}
\references{
Groeneboom, P. and Hendrickx, K. (2017). The nonparametric bootstrap for the current status model. \url{https://arxiv.org/abs/1701.07359}
}
\seealso{
\code{\link{ComputeConfIntervals}}
}
