# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'@title Pointwise Confidence Intervals under Current Status data
#'
#'@description The function ComputeConfIntervals computes pointwise confidence intervals for the distribution function under current status data.
#'The confidence intervals are based on the Smoothed Maximum likelihood Estimator and constructed using the nonparametric bootstrap.
#'
#'@param data Dataframe with three variables:
#'\describe{
#'     \item{t}{Observation points t sorted in ascending order. All observations need to be positive. The total number of unique observation points equals \code{length(t)}.}
#'     \item{freq1}{Frequency of observation t satisfying \eqn{x \le t}.
#'                   The total number of observations with censoring indicator \eqn{\delta =1} equals \code{sum(freq1)}. }
#'     \item{freq2}{Frequency of observation t. The sample size equals \code{sum(freq2)}. If no tied observations are present in the data \code{length(t)} equals \code{sum(freq2)}. }
#'}
#'
#'@param x numeric vector containing the points where the confidence intervals are computed.
#'         This vector needs to be contained within the observation interval: \eqn{t[1] < min(x) \le max(x) < t[n]}.
#'
#'@param alpha confidence level of pointwise confidence intervals.
#'
#'@param bw numeric vector of size \code{length(x)}.
#'       This vector contains the pointwise bandwidth values for each point in the vector x.
#'
#'@return List with 5 variables:
#'
#'\describe{
#'     \item{MLE }{Maximum Likelihood Estimator. This is a matrix of dimension (m+1)x2 where m is the number of jump points of the MLE.
#'                  The first column consists of the point zero and the jump locations of the MLE. The second column contains the value zero and the values of the MLE at the jump points. }
#'     \item{SMLE }{Smoothed Maximum Likelihood Estimator. This is a vector of size \code{length(x)} containing the values of the SMLE for each point in the vector x. }
#'     \item{CI }{pointwise confidence interval. This is a matrix of dimension \code{length(x)}x2.
#'                The first resp. second column contains the lower resp. upper values of the confidence intervals for each point in x.}
#'     \item{Studentized}{points in x for which Studentized nonparametric bootstrap confidence intervals are computed. }
#'     \item{NonStudentized}{points in x for which classical nonparametric bootstrap confidence intervals are computed.}
#' }
#'
#'@details In the current status model, the variable of interest \eqn{X} with distribution function \eqn{F} is not observed directly.
#'A censoring variable \eqn{T} is observed instead together with the indicator \eqn{\Delta = (X \le T)}.
#'ComputeConfIntervals computes the pointwise \code{1-alpha} bootstrap confidence intervals around the SMLE of \eqn{F} based on a sample of size \code{n <- sum(data$freq2)}.
#'
#'The bandwidth parameter vector that minimizes the pointwise Mean Squared Error using the subsampling principle in combination with undersmoothing is returned by the function \code{\link{ComputeBW}}.
#'
#'The default method for constructing the confidence intervals in [Groeneboom & Hendrickx (2017)] is based on estimating the asymptotic variance of the SMLE.
#'When the bandwidth is small for some point in x, the variance estimate of the SMLE at this point might not exist.
#'If this happens the Non-Studentized confidence interval is returned for this particular point in x.
#'
#'@seealso \code{vignette("curstatCI")}
#'
#'@examples
#'library(Rcpp)
#'library(curstatCI)
#'
#'# sample size
#'n <- 1000
#'
#'# Uniform data  U(0,2)
#'set.seed(2)
#'y <- runif(n,0,2)
#'t <- runif(n,0,2)
#'delta <- as.numeric(y <= t)
#'
#'A<-cbind(t[order(t)], delta[order(t)], rep(1,n))
#'
#'# x vector
#'grid<-seq(0.1,1.9 ,by = 0.1)
#'
#'# data-driven bandwidth vector
#'bw <- ComputeBW(data =A, x = grid)
#'
#'# pointwise confidence intervals at grid points:
#'out<-ComputeConfIntervals(data = A,x =grid,alpha = 0.05, bw = bw)
#'
#'left <- out$CI[,1]
#'right <- out$CI[,2]
#'
#'plot(grid, out$SMLE,type ='l', ylim=c(0,1), main= "",ylab="",xlab="",las=1)
#'points(grid, left, col = 4)
#'points(grid, right, col = 4)
#'segments(grid,left, grid, right)
#'
#'@references Groeneboom, P. and Hendrickx, K. (2017). The nonparametric bootstrap for the current status model. \url{https://arxiv.org/abs/1701.07359}
#'
#'@export
ComputeConfIntervals <- function(data, x, alpha, bw) {
    .Call('_curstatCI_ComputeConfIntervals', PACKAGE = 'curstatCI', data, x, alpha, bw)
}

#'@title Data-driven bandwidth vector
#'
#'@description The function ComputeBW computes the bandwidth that minimizes the pointwise Mean Squared Error using the subsampling principle in combination with undersmoothing.
#'
#'@param data Dataframe with three variables:
#'\describe{
#'     \item{t}{Observation points t sorted in ascending order. All observations need to be positive. The total number of unique observation points equals \code{length(t)}.}
#'     \item{freq1}{Frequency of observation t satisfying \eqn{x \le t}.
#'                   The total number of observations with censoring indicator \eqn{\delta =1} equals \code{sum(freq1)}. }
#'     \item{freq2}{Frequency of observation t. The sample size equals \code{sum(freq2)}. If no tied observations are present in the data \code{length(t)} equals \code{sum(freq2)}. }
#'}
#'
#'@param x numeric vector containing the points where the confidence intervals are computed.
#'
#'
#'@return bw data-driven bandwidth vector of size \code{length(x)} containing the bandwidth value for each point in x.
#'
#'
#'@seealso \code{vignette("curstatCI")}
#'
#'@examples
#'library(Rcpp)
#'library(curstatCI)
#'
#'# sample size
#'n <- 1000
#'
#'# truncated exponential distribution on (0,2)
#'set.seed(100)
#' t <- rep(NA, n)
#' delta <- rep(NA, n)
#' for(i in (1:n) ){
#'   x<-runif(1)
#'   y<--log(1-(1-exp(-2))*x)
#'   t[i]<-2*runif(1);
#'   if(y<=t[i]){ delta[i]<-1}
#'   else{delta[i]<-0}}
#'
#'A<-cbind(t[order(t)], delta[order(t)], rep(1,n))
#'
#'# x vector
#'grid<-seq(0.1,1.9 ,by = 0.1)
#'
#'# data-driven bandwidth vector
#'bw <- ComputeBW(data =A, x = grid)
#'plot(grid, bw)
#'
#'@references Groeneboom, P. and Hendrickx, K. (2017). The nonparametric bootstrap for the current status model. \url{https://arxiv.org/abs/1701.07359}
#'@export
ComputeBW <- function(data, x) {
    .Call('_curstatCI_ComputeBW', PACKAGE = 'curstatCI', data, x)
}

#'@title Maximum Likelihood Estimator
#'
#'@description The function ComputeMLE computes the Maximum Likelihood Estimator of the distribution function under current status data.
#'
#'@param data Dataframe with three variables:
#'\describe{
#'     \item{t}{Observation points t sorted in ascending order. All observations need to be positive. The total number of unique observation points equals \code{length(t)}.}
#'     \item{freq1}{Frequency of observation t satisfying \eqn{x \le t}.
#'                   The total number of observations with censoring indicator \eqn{\delta =1} equals \code{sum(freq1)}. }
#'     \item{freq2}{Frequency of observation t. The sample size equals \code{sum(freq2)}. If no tied observations are present in the data \code{length(t)} equals \code{sum(freq2)}. }
#'}
#'
#'@details In the current status model, the variable of interest \eqn{X} with distribution function \eqn{F} is not observed directly.
#'A censoring variable \eqn{T} is observed instead together with the indicator \eqn{\Delta = (X \le T)}.
#' ComputeMLE computes the MLE of \eqn{F} based on a sample of size \code{n <- sum(data$freq2)}.
#'
#'
#'
#'@return Dataframe with two variables :
#'\describe{
#'     \item{x}{jump locations of the MLE}
#'     \item{mle}{MLE evaluated at the jump locations}
#' }
#'
#'@references Groeneboom, P. and Hendrickx, K. (2017). The nonparametric bootstrap for the current status model. \url{https://arxiv.org/abs/1701.07359}
#'
#'@seealso \code{\link{ComputeConfIntervals}}
#'
#'
#'@examples
#'library(Rcpp)
#'library(curstatCI)
#'
#'# sample size
#'n <- 1000
#'
#'# Uniform data  U(0,2)
#'set.seed(2)
#'y <- runif(n,0,2)
#'t <- runif(n,0,2)
#'delta <- as.numeric(y <= t)
#'
#'A<-cbind(t[order(t)], delta[order(t)], rep(1,n))
#'mle <-ComputeMLE(A)
#'plot(mle$x, mle$mle,type ='s', ylim=c(0,1), main= "",ylab="",xlab="",las=1)
#'
#'@export
ComputeMLE <- function(data) {
    .Call('_curstatCI_ComputeMLE', PACKAGE = 'curstatCI', data)
}

#'@title Smoothed Maximum Likelihood Estimator
#'
#'@description The function ComputeSMLE computes the Smoothed Maximum Likelihood Estimator of the distribution function under current status data.
#'
#'@param data Dataframe with three variables:
#'\describe{
#'     \item{t}{Observation points t sorted in ascending order. All observations need to be positive. The total number of unique observation points equals \code{length(t)}.}
#'     \item{freq1}{Frequency of observation t satisfying \eqn{x \le t}.
#'                   The total number of observations with censoring indicator \eqn{\delta =1} equals \code{sum(freq1)}. }
#'     \item{freq2}{Frequency of observation t. The sample size equals \code{sum(freq2)}. If no tied observations are present in the data \code{length(t)} equals \code{sum(freq2)}. }
#'}
#'
#'@param bw numeric vector of size \code{length(x)}. This vector contains the pointwise bandwidth values for each point in the vector x.
#'
#'@param x numeric vector containing the points where the confidence intervals are computed.
#'
#'@details In the current status model, the variable of interest \eqn{X} with distribution function \eqn{F} is not observed directly.
#'A censoring variable \eqn{T} is observed instead together with the indicator \eqn{\Delta = (X \le T)}.
#' ComputeSMLE computes the SMLE of \eqn{F} based on a sample of size \code{n <- sum(data$freq2)}.
#' The bandwidth parameter vector that minimizes the pointwise Mean Squared Error using the subsampling principle in combination with undersmoothing is returned by the function \link{ComputeBW}.
#'
#'@return SMLE(x) Smoothed Maximum Likelihood Estimator. This is a vector of size \code{length(x)} containing the values of the SMLE for each point in the vector x.
#'
#'@references Groeneboom, P. and Hendrickx, K. (2017). The nonparametric bootstrap for the current status model. \url{https://arxiv.org/abs/1701.07359}
#'
#'@seealso \code{\link{ComputeConfIntervals}}
#'
#'@examples
#'library(Rcpp)
#'library(curstatCI)
#'
#'# sample size
#'n <- 1000
#'
#'# Uniform data  U(0,2)
#'set.seed(2)
#'y <- runif(n,0,2)
#'t <- runif(n,0,2)
#'delta <- as.numeric(y <= t)
#'
#'A<-cbind(t[order(t)], delta[order(t)], rep(1,n))
#'grid <-seq(0,2 ,by = 0.01)
#'
#'# bandwidth vector
#'h<-rep(2*n^-0.2,length(grid))
#'
#'smle <-ComputeSMLE(A,grid,h)
#'plot(grid, smle,type ='l', ylim=c(0,1), main= "",ylab="",xlab="",las=1)
#'
#'
#'@export
ComputeSMLE <- function(data, x, bw) {
    .Call('_curstatCI_ComputeSMLE', PACKAGE = 'curstatCI', data, x, bw)
}

