% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percent.R
\name{percent}
\alias{percent}
\alias{pct}
\title{Designate a numeric vector as a percent.}
\usage{
percent(x, ...)

pct(x, places = attr(x, "places") \%||\% getOption("percent::places", 2),
  threshold = attr(x, "threshold") \%||\% getOption("percent::threshold",
  1 * 10^-places), ...)
}
\arguments{
\item{x}{a numeric object indicating a percentage.}

\item{...}{additional formatting arguments.}

\item{places}{Places to show after the decimal point.}

\item{threshold}{The minimum absolute percentage to show.}
}
\value{
\itemize{
\item For \code{pct()} a string formatted for a percent.
\item For \code{percent()} the same as pct but is classed as a 'percent'
and includes attributes for the raw value.
}
}
\description{
The percentage is stored as a formatted string with the original
value as an attribute.  The formatted value is what will most often
be needed but but allows for the original value to be recovered
when the attribute is not stripped off.
}
\section{Functions}{
\itemize{
\item \code{pct}: Format a number as a percent.
}}

\examples{
pct(2/3)           #<-- no class
(x<- percent(2/3)) #<-- has class
as.numeric(x)
}
