\name{pmeans.hcoef}
\alias{pmeans.hcoef}
\concept{MCMC}
\concept{hierarchical model}
\title{Posterior mean for each regression variable}
\description{
  \code{pmeans.hcoef} processes the MCMC simulation to evaluate the posterior mean of the regression variables.}
\usage{
pmeans.hcoef(x,burnin=trunc(.1*R))}
\arguments{
  \item{x}{"betadraw" object generated by the MCMC simulation}
  \item{burnin}{n. of draws to burnin, def: .1*R}
}
\value{
  \item{pmeans}{Posterior Means of Coefficients}}
\details{Post-process MCMC simulation}
\seealso{
  \code{\link{cudaMultireg.slice}}
  \code{\link{read.fmrisample}}
  \code{\link{regpostsim}}
  \code{\link{post.simul.betadraw}}
  \code{\link{post.simul.hist}}}
\examples{
\dontrun{
slicedata <- read.fmrisample(slice=3)
fsave <- "/tmp/simultest.sav"
answ <- readline("Run MCMC simulation first ? ")
run <- FALSE
if (substr(answ, 1, 1) == "y") { run <- TRUE }
if(run) {
	out <- cudaMultireg.slice(slicedata, fsave=fsave )
} else {
	load(file=fsave)
	cat("loaded",fsave,"\n")
}
pmeans <- pmeans.hcoef(out$betadraw)
}
}
\keyword{ utilities }
