% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endian.R
\name{aperm_vector_to_array}
\alias{aperm_vector_to_array}
\title{Permute a linear vector of data into an R array}
\usage{
aperm_vector_to_array(x, src, flipy = FALSE, simplify_matrix = TRUE)
}
\arguments{
\item{x}{vector}

\item{src}{Specification of source dimensions in the order of presentation
in the source data. This must a named integer vector with 
the names "planes", "rows", "cols" (and their corresponding sizes)
in the order in which they occur in the data.  The first 
named element must always be "planes".  Use \code{planes = 1} to
indicate that this is matrix data.}

\item{flipy}{flip the array vertically. Default: FALSE}

\item{simplify_matrix}{If the resulting array only has a single plane, 
should this be simplified to a matrix? Default: TRUE}
}
\value{
array or matrix
}
\description{
Permute a linear vector of data into an R array
}
\examples{
# Convert a vector of packed RGB data to an array with 3 planes
x <- c(
  'r0', 'g0', 'b0',   'r1', 'g1', 'b1',   'r2', 'g2', 'b2',   
  'r3', 'g3', 'b3',   'r4', 'g4', 'b4',   'r5', 'g5', 'b5'
)
aperm_vector_to_array(x, src = c(planes = 3, cols = 3, rows = 2))
}
\seealso{
Other data permutation functions: 
\code{\link{aperm_array_to_vector}()},
\code{\link{flip_endian}()}
}
\concept{data permutation functions}
