% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctModelHigherOrder.R
\name{ctModelHigherOrder}
\alias{ctModelHigherOrder}
\title{Raise the order of a ctsem model object of type 'omx'.}
\usage{
ctModelHigherOrder(
  ctm,
  indices,
  diffusion = TRUE,
  crosseffects = FALSE,
  cint = FALSE,
  explosive = FALSE
)
}
\arguments{
\item{ctm}{ctModel}

\item{indices}{Vector of integers, which latents to raise the order of.}

\item{diffusion}{Shift the diffusion parameters / values to the higher order?}

\item{crosseffects}{Shift cross coupling parameters of the DRIFT matrix to the higher order?}

\item{cint}{shift continuous intercepts to higher order?}

\item{explosive}{Allow explosive (non equilibrium returning) processes?}
}
\value{
extended ctModel
}
\description{
Raise the order of a ctsem model object of type 'omx'.
}
\examples{
om <- ctModel(LAMBDA=diag(1,2),DRIFT=0, 
  MANIFESTMEANS=0,type='omx',Tpoints=4)
  
om <- ctModelHigherOrder(om,1:2)
print(om$DRIFT)

m <- ctStanModel(om)
print(m$pars)
}
