% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ctrLoadQueryIntoDbEuctr}
\alias{ctrLoadQueryIntoDbEuctr}
\title{ctrLoadQueryIntoDbEuctr}
\usage{
ctrLoadQueryIntoDbEuctr(
  queryterm = queryterm,
  register,
  euctrresults,
  euctrresultshistory,
  euctrresultspdfpath,
  annotation.text,
  annotation.mode,
  parallelretrievals,
  only.count,
  con,
  verbose,
  queryupdateterm
)
}
\arguments{
\item{queryterm}{Either a string with the full URL of a search in
a register, or the data frame returned by the
\link{ctrGetQueryUrl} or the
\link{dbQueryHistory} functions, or, together with parameter
\code{register}, a string with query elements of a search URL.
The queryterm is recorded in the \code{collection} for later
use to update records.}

\item{register}{String with abbreviation of register to query,
either "EUCTR", "CTGOV" or "ISRCTN". Not needed
if \code{queryterm} provide the information which register to
query (see \code{queryterm}).}

\item{euctrresults}{If \code{TRUE}, also download available
results when retrieving and loading trials from EUCTR. This
slows down this function. (For CTGOV, all available results
are always retrieved and loaded.)}

\item{euctrresultshistory}{If \code{TRUE}, also download
available history of results publication in EUCTR.
This is quite time-consuming (default is \code{FALSE}).}

\item{euctrresultspdfpath}{If a valid directory is specified,
save PDF files of result publications from EUCTR into
this directory (default is \code{NULL}).}

\item{annotation.text}{Text to be including in the records
retrieved with the current query, in the field "annotation".}

\item{annotation.mode}{One of "append" (default), "prepend"
or "replace" for new annotation.text with respect to any
existing annotation for the records retrieved with the
current query.}

\item{parallelretrievals}{Number of parallel downloads of
information from the register, defaults to 10.}

\item{only.count}{Set to \code{TRUE} to return only the
number of trial records found in the register for the query.
Does not load trial information into the database.
Default is \code{FALSE}.}

\item{con}{A \link[nodbi]{src} connection object, as obtained with
nodbi::\link[nodbi]{src_mongo}() or nodbi::\link[nodbi]{src_sqlite}()}

\item{verbose}{Printing additional information if set to
\code{TRUE}; default is \code{FALSE}.}
}
\description{
ctrLoadQueryIntoDbEuctr
}
\keyword{internal}
