/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.bintree.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Bintree {
    private Root root = new Root();
    private double minExtent = 1.0;

    public static Interval ensureExtent(Interval itemInterval, double minExtent) {
        double max;
        double min = itemInterval.getMin();
        if (min != (max = itemInterval.getMax())) {
            return itemInterval;
        }
        if (min == max) {
            max = (min -= minExtent / 2.0) + minExtent / 2.0;
        }
        return new Interval(min, max);
    }

    public int depth() {
        if (this.root != null) {
            return this.root.depth();
        }
        return 0;
    }

    public int size() {
        if (this.root != null) {
            return this.root.size();
        }
        return 0;
    }

    public int nodeSize() {
        if (this.root != null) {
            return this.root.nodeSize();
        }
        return 0;
    }

    public void insert(Interval itemInterval, Object item) {
        this.collectStats(itemInterval);
        Interval insertInterval = Bintree.ensureExtent(itemInterval, this.minExtent);
        this.root.insert(insertInterval, item);
    }

    public Iterator iterator() {
        ArrayList foundItems = new ArrayList();
        this.root.addAllItems(foundItems);
        return foundItems.iterator();
    }

    public List query(double x) {
        return this.query(new Interval(x, x));
    }

    public List query(Interval interval) {
        ArrayList foundItems = new ArrayList();
        this.query(interval, foundItems);
        return foundItems;
    }

    public void query(Interval interval, Collection foundItems) {
        this.root.addAllItemsFromOverlapping(interval, foundItems);
    }

    private void collectStats(Interval interval) {
        double del = interval.getWidth();
        if (del < this.minExtent && del > 0.0) {
            this.minExtent = del;
        }
    }
}

