/*
 * Decompiled with CFR 0.152.
 */
package org.geotiff.epsg;

import org.geotiff.epsg.GeographicCS;
import org.geotiff.epsg.InvalidCodeException;
import org.geotiff.epsg.ProjectedCS;

public abstract class HorizontalCS {
    public static int WGS84 = 4326;
    private int code;

    protected HorizontalCS(int code) {
        this.setCode(code);
    }

    protected void setCode(int aCode) {
        this.code = aCode;
    }

    public int getCode() {
        return this.code;
    }

    public abstract HorizontalCS getGeographicCS();

    public static HorizontalCS create(int code) throws InvalidCodeException {
        if (code < 0) {
            throw new InvalidCodeException("whatever");
        }
        if (code < 5000) {
            return new GeographicCS(code);
        }
        return new ProjectedCS(code);
    }
}

