% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_ma.R
\name{alma}
\alias{alma}
\title{Add Arnaud Legoux Moving Average (ALMA) to the chart}
\usage{
alma(
 price  = "close",
 n      = 9,
 offset = 0.85,
 sigma  = 6,
 ...
)
}
\arguments{
\item{price}{A \link{character}-vector of \link{length} 1. "close" by default
The name of the vector to passed into \link[TTR:MovingAverages]{TTR::ALMA}.}

\item{n}{Number of periods to average over. Must be between 1 and
\code{nrow(x)}, inclusive.}

\item{offset}{Percentile at which the center of the distribution should occur.}

\item{sigma}{Standard deviation of the distribution.}

\item{...}{For internal use. Please ignore.}
}
\value{
A \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:add_trace]{plotly::add_lines()}}-wrapper function that
interacts with \link{TTR}'s moving average family of functions.
The function adds moving average indicators to the main \code{\link[=chart]{chart()}}.
}
\examples{
# script start;

cryptoQuotes::chart(
  ticker = BTC,
  main   = kline(),
  indicator = list(
    cryptoQuotes::ema(n = 7),
    cryptoQuotes::sma(n = 14),
    cryptoQuotes::wma(n = 21)
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other moving average indicators: 
\code{\link{dema}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{sma}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other main chart indicators: 
\code{\link{add_event}()},
\code{\link{bollinger_bands}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{sma}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{main chart indicators}
\concept{moving average indicators}
