% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional-transform.R
\name{conditionalTransform}
\alias{conditionalTransform}
\title{Conditional transformation}
\usage{
conditionalTransform(..., data, else_condition = NA, type = NULL,
  categories = NULL, formulas = NULL)
}
\arguments{
\item{...}{a list of conditions to evaluate (as formulas, see Details) as well as
other properties to pass to the new conditional variable (i.e. alias, description)}

\item{data}{a Crunch dataset object to use}

\item{else_condition}{a default value to use if none of the conditions are
true (default: \code{NA})}

\item{type}{a character that is either "categorical", "text", "numeric" what
type of output should be returned? If \code{NULL}, the type of the source
variable will be used. (default: \code{NULL}) The source variables will be
converted to this type if necessary.}

\item{categories}{a vector of characters if \code{type="categorical"}, these are
all of the categories that should be in the resulting variable, in the order
they should be in the resulting variable or a set of Crunch categories.}

\item{formulas}{a list of conditions to evaluate (as formulas, see Details). If
specified, \code{...} must not contain other formulas specifying conditions.}
}
\value{
a Crunch \code{VariableDefinition}
}
\description{
Create a new variable that has values when specific conditions are met.
Conditions are specified using a series of formulas: the left-hand side is
the condition that must be true (a \code{CrunchLogicalExpr}) and the right-hand
side is where to get the value if the condition on the left-hand side is
true. This is commonly a Crunch variable but may be a string or numeric
value, depending on the type of variable you're constructing.
}
\details{
The type of the new variable can depend on the type(s) of the source
variable(s).  By default (\code{type=NULL}), the type of the new variable will be
the type of all of the source variables (that is, if all of the source
variables are text, the new variable type will be text, if all of the
source variables are categorical, the new variable will be categorical).
If there are multiple types in the source variables, the result will be a
text variable. The default behavior can be overridden by specifying
\code{type = "categorical"}, \code{"text"}, or \code{"numeric"}.

\code{conditionalTransform} is similar to \code{makeCaseVariable}; however,
\code{conditionalTransform} can use other Crunch variables as a source of a
variable, whereas, \code{makeCaseVariable} can only use characters. This
additional power comes at a cost: \code{makeCaseVariable} can be executed
entirely on Crunch servers, so no data needs to be downloaded or uploaded
to/from the local R session. \code{conditionalTransform} on the other hand will
download the data necessary to construct the new variable.
}
\examples{
\dontrun{

ds$cat_opinion <- conditionalTransform(pet1 == 'Cat' ~ Opinion1,
                                       pet2 == 'Cat' ~ Opinion2,
                                       pet3 == 'Cat' ~ Opinion3,
                                       data = ds,
                                       name = "Opinion of Cats")
}
}
