% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consent.R
\name{consent}
\alias{consent}
\alias{with_consent}
\title{Give consent to do things that require permission}
\usage{
consent()

with_consent(expr)
}
\arguments{
\item{expr}{Code to evaluate with consent}
}
\value{
\code{consent} returns an S3 class "contextManager" object, which
you can use with \code{with}. \code{with_consent} evaluates its arguments
inside the \code{consent} context.
}
\description{
Potentially destructive actions require that you confirm that you really
want to do them. If you're running a script and you know that you want to
perform those actions, you can preemptively provide \code{consent}.
}
\examples{
\dontrun{
with(consent(), delete(ds))
# Equivalent to:
with_consent(delete(ds))
}
}
\seealso{
\link{with-context-manager} \link{ContextManager}
}

