% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curl-options.R
\name{curl-options}
\alias{curl-options}
\alias{user-agent}
\alias{verbose}
\alias{timeout}
\title{curl options}
\description{
With the \code{opts} parameter you can pass in various
curl options, including user agent string, whether to get verbose
curl output or not, setting a timeout for requests, and more. See
\code{\link[curl:curl_options]{curl::curl_options()}} for all the options you can use.
}
\details{
A progress helper will be coming soon.
}
\examples{
\dontrun{
# set curl options on client initialization
(res <- HttpClient$new(
  url = "https://httpbin.org",
  opts = list(
    verbose = TRUE,
    useragent = "hello world"
  )
))
res$opts
res$get('get')

# or set curl options when performing HTTP operation
(res <- HttpClient$new(url = "https://httpbin.org"))
res$get('get', verbose = TRUE)
res$get('get', stuff = "things")
res$get('get', httpget = TRUE)

# set a timeout
(res <- HttpClient$new(
  url = "https://httpbin.org",
  opts = list(timeout_ms = 1)
))
res$get('get')
}
}
