## ----echo=FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  comment = "#>",
  collapse = TRUE,
  warning = FALSE,
  message = FALSE
)

## ----eval=FALSE----------------------------------------------------------
#  install.packages("crul")

## ----eval=FALSE----------------------------------------------------------
#  devtools::install_github("ropensci/crul")

## ------------------------------------------------------------------------
library("crul")

## ------------------------------------------------------------------------
(x <- HttpClient$new(
  url = "https://httpbin.org",
  opts = list(
    timeout = 1
  ),
  headers = list(
    a = "hello world"
  )
))

## ------------------------------------------------------------------------
x$opts

## ------------------------------------------------------------------------
x$headers

## ------------------------------------------------------------------------
res <- x$get("get")

## ------------------------------------------------------------------------
res$status_code

## ------------------------------------------------------------------------
res$content

## ------------------------------------------------------------------------
res$method

## ------------------------------------------------------------------------
res$request_headers

## ------------------------------------------------------------------------
res$response_headers

## ------------------------------------------------------------------------
res$parse()
jsonlite::fromJSON(res$parse())

## ------------------------------------------------------------------------
x$post(
  path = "post", 
  body = list(hello = "world")
)

## ------------------------------------------------------------------------
x <- HttpClient$new(url = "https://httpbin.org")
f <- tempfile()
res <- x$get(disk = f)
# when using write to disk, content is a path
res$content 

## ------------------------------------------------------------------------
readLines(res$content, n = 10)

## ------------------------------------------------------------------------
(x <- HttpClient$new(url = "https://httpbin.org"))
res <- x$get('stream/5', stream = function(x) cat(rawToChar(x)))
# when streaming, content is NULL
res$content 

