% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_vec.R
\name{map_vec}
\alias{map_vec}
\alias{map2_vec}
\alias{pmap_vec}
\alias{imap_vec}
\alias{xmap_vec}
\title{Mapping functions that automatically determine type}
\usage{
map_vec(.x, .f, ...)

map2_vec(.x, .y, .f, ...)

pmap_vec(.l, .f, ...)

imap_vec(.x, .f, ...)

xmap_vec(.l, .f, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}}

\item{.y}{A vector the same length as \code{.x}.
Vectors of length 1 will be recycled.}

\item{.l}{A list of vectors, such as a data frame.
The length of .l determines the number of arguments that .f will be called
with.
List names will be used if present.}
}
\value{
Equivalent to the typed variants of \code{\link[purrr:map]{purrr::map()}}, \code{\link[purrr:map2]{purrr::map2()}},
\code{\link[purrr:map2]{purrr::pmap()}}, \code{\link[purrr:imap]{purrr::imap()}} and \code{\link[=xmap]{xmap()}} with the type automatically
determined.

If the output contains multiple types, the type is determined from
the highest type of the components in the hierarchy \link{raw} < \link{logical} <
\link{integer} < \link{double} < \link{complex} < \link{character} < \link{list} (as in \code{\link[=c]{c()}}).

If the output contains elements that cannot be coerced to vectors
(e.g. lists), the output will be a list.
}
\description{
These functions work exactly the same as typed variants of \code{\link[purrr:map]{purrr::map()}},
\code{\link[purrr:map2]{purrr::map2()}}, \code{\link[purrr:map2]{purrr::pmap()}}, \code{\link[purrr:imap]{purrr::imap()}} and \code{\link[=xmap]{xmap()}}
(e.g. \code{\link[purrr:map]{purrr::map_chr()}}), but automatically determine the type.
}
\examples{
fruits   <- c("apple", "banana", "cantaloupe", "durian", "eggplant")
desserts <- c("bread", "cake", "cupcake", "muffin", "streudel")
x        <- sample(5)
y        <- sample(5)
z        <- sample(5)
names(z) <- fruits

map_vec(x, ~ . ^ 2)
map_vec(fruits, paste0, "s")

map2_vec(x, y, ~ .x + .y)
map2_vec(fruits, desserts, paste)

pmap_vec(list(x, y, z), sum)
pmap_vec(list(x, fruits, desserts), paste)

imap_vec(x, ~ .x + .y)
imap_vec(x, ~ paste0(.y, ": ", .x))
imap_vec(z, paste)

xmap_vec(list(x, y), ~ .x * .y)
xmap_vec(list(fruits, desserts), paste)
}
\seealso{
The original functions: \code{\link[purrr:map]{purrr::map()}}, \code{\link[purrr:map2]{purrr::map2()}},
\code{\link[purrr:map2]{purrr::pmap()}}, \code{\link[purrr:imap]{purrr::imap()}} and \code{\link[=xmap]{xmap()}}

Parallelized equivalents: \code{\link[=future_map_vec]{future_map_vec()}}, \code{\link[=future_map2_vec]{future_map2_vec()}},
\code{\link[=future_pmap_vec]{future_pmap_vec()}}, \code{\link[=future_imap_vec]{future_imap_vec()}} and \code{\link[=future_xmap_vec]{future_xmap_vec()}}
}
