% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_mean.R
\name{daily_mean}
\alias{daily_mean}
\title{Mean of daily weather variable values between two dates}
\usage{
daily_mean(
  data,
  var = NULL,
  datevar = NULL,
  ndays = 5,
  na.rm = FALSE,
  startdate = NULL,
  enddate = NULL,
  monitor = FALSE,
  warn.consecutive = TRUE,
  ...
)
}
\arguments{
\item{data}{Tibble or dataframe of daily weather data}

\item{var}{Variable(s) to be extracted (Default: radn). Several columns
may be specified using column names \code{c(variable1, variable2, ...)}}

\item{datevar}{Date variable specifying day (Default: date_met)}

\item{ndays}{Number of days after/before the start or end date,
respectively. Ignored of both the start and end dates are
specified (Default: 5)}

\item{na.rm}{Used for calculations (Default: FALSE)}

\item{startdate}{Start date of data to be extracted}

\item{enddate}{Final date of data to be extracted}

\item{monitor}{For debugging. Prints data and dates. (Default:
FALSE)}

\item{warn.consecutive}{A logical indicating whether to check that
dates are consecutive, that none are missing and provide a warning if
not (Default:TRUE)}

\item{...}{options to be passed to \code{mean} calculation}
}
\value{
Numeric variable containing the daily mean of the weather
variable \code{var} during the specified period.
}
\description{
Calculates the average of daily values of the variable between two
dates from a tibble or data frame of daily weather
data. Alternatively, a number of days before or after a specific
date may be specified. Typically this would be used for
temperature, rainfall or solar radiation.
}
\details{
The mean is returned but if there are any missing values, then the
mean is set to \code{NA} since the default \code{na.rm} is
\code{TRUE}. Note that if there are any missing dates, then a
warning is issued but the mean of non-missing values is returned.

If any values are missing, while the calculated mean may prove
useful, it will not include all the data and so may lead to biased
estimates. Hence, in these cases, the appropriateness of the
estimate will depend on the exact circumstances of the missing
data and so this decision is left to the user.
}
\examples{
##  Selected calculations
library(tidyverse)
daily_mean(boonah, enddate = crop$flower_date[4], ndays = 3,
                    monitor = TRUE)
daily_mean(boonah, enddate = crop$harvest_date[4], ndays = 3,
                    monitor = TRUE)
daily_mean(boonah, startdate = crop$flower_date[4],
                    enddate = crop$harvest_date[4], monitor = TRUE)

## Add selected daily means to crop tibble
crop2 <- crop \%>\%
  mutate(mean_maxtemp_post_sow_7d =
          map_dbl(sowing_date, function(x)
            daily_mean(boonah, var = maxt, startdate = x, ndays = 7)),
          mean_rad_flower_harvest =
            map2_dbl(flower_date, harvest_date, function(x, y)
              daily_mean(boonah, var = radn, startdate = x, enddate = y)))
crop2

}
\seealso{
\code{\link{mean}}, \code{\link{cumulative}},
\code{\link{growing_degree_days}},
\code{\link{stress_days_over}}, and
\code{\link{weather_extract}}
}
