% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tdmurl.R
\name{as_tdmurl}
\alias{as_tdmurl}
\alias{as_tdmurl.tdmurl}
\alias{as_tdmurl.character}
\title{Coerce a url to a tdmurl with a specific type}
\usage{
as_tdmurl(url, type, doi)

\method{as_tdmurl}{tdmurl}(url, type, doi)

\method{as_tdmurl}{character}(url, type, doi = NULL)
}
\arguments{
\item{url}{(character) A URL.}

\item{type}{(character) One of 'xml' (default), 'html', 'plain', 'pdf',
'unspecified', or 'all'}

\item{doi}{(character) A DOI, optional, default: \code{NULL}}
}
\description{
A tmd url is just a URL with some attributes to make it easier
to handle within other functions in this package.
}
\examples{
as_tdmurl("http://downloads.hindawi.com/journals/bmri/2014/201717.xml",
   "xml")
as_tdmurl("http://downloads.hindawi.com/journals/bmri/2014/201717.pdf",
   "pdf")
out <-
 as_tdmurl("http://downloads.hindawi.com/journals/bmri/2014/201717.pdf",
   "pdf", "10.1155/2014/201717")
attributes(out)
identical(attr(out, "type"), "pdf")
}
