% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{h_default_if_empty}
\alias{h_default_if_empty}
\title{Getting the default value for an empty object}
\usage{
h_default_if_empty(x, default)
}
\arguments{
\item{x}{(\code{any}) \cr an object to handle. It can be any object for which
\code{\link[=length]{length()}} function is defined.}

\item{default}{(\code{any}) \cr a default value for \code{x} object.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A simple helper function that sets a default value for an empty or missing object,
that is an object for which \code{\link[=length]{length()}} function returns \code{0L} or it has length 1
and \code{\link[=is.na]{is.na()}} returns \code{TRUE}.
}
\examples{
h_default_if_empty(character(0), default = "default label")
h_default_if_empty("custom label", default = "default label")
h_default_if_empty(NA, default = "default label")
}
